/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import com.rc.retroweaver.runtime.ClassLiteral;
import jace.autoproxy.ClassSource;
import jace.metaclass.ArrayMetaClass;
import jace.metaclass.MetaClass;
import jace.metaclass.MetaClassFactory;
import jace.parser.ClassFile;
import jace.parser.ConstantPool;
import jace.parser.constant.ClassConstant;
import jace.parser.constant.Constant;
import jace.parser.constant.FieldRefConstant;
import jace.parser.constant.InterfaceMethodRefConstant;
import jace.parser.constant.MethodRefConstant;
import jace.parser.constant.NameAndTypeConstant;
import jace.parser.constant.TypedConstant;
import jace.parser.field.ClassField;
import jace.parser.method.ClassMethod;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefVerifier {
    List<String> classpath;
    String classfile;
    ClassFile file;
    ConstantPool pool;
    ClassSource classSource;
    Set<String> failedClasses;
    Listener listener;
    private static final String nl = System.getProperty("line.separator");
    private static Set<String> primitiveTypes = new HashSet<String>();

    public RefVerifier(List<String> classpath, Listener listener) {
        this.classpath = classpath;
        this.classSource = new ClassSource(classpath);
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(String classfile) throws IOException {
        this.failedClasses = new HashSet<String>();
        this.classfile = classfile;
        this.file = new ClassFile(classfile);
        this.pool = this.file.getConstantPool();
        this.listener.verifyStarted(new StringBuffer().append("Verifying ").append(classfile).toString());
        MetaClassFactory mcf = new MetaClassFactory();
        block39: for (int i = 0; i < this.pool.getSize(); ++i) {
            InputStream input;
            TypeInfo t;
            Constant c = this.pool.getConstant(i);
            if (c instanceof ClassConstant) {
                String className = c.toString();
                MetaClass metaClass = mcf.getMetaClass(className, false, false);
                if (metaClass instanceof ArrayMetaClass) {
                    metaClass = ((ArrayMetaClass)metaClass).getBaseClass();
                    className = metaClass.getFullyQualifiedName("/");
                    if (metaClass.isPrimitive()) continue;
                    metaClass = mcf.getMetaClass(className, true, false);
                    className = metaClass.getFullyQualifiedName("/");
                }
                boolean couldBeFound = true;
                InputStream input2 = null;
                try {
                    this.classSource.openClass(className);
                }
                catch (NoClassDefFoundError e) {
                    couldBeFound = false;
                }
                finally {
                    try {
                        if (input2 != null) {
                            input2.close();
                        }
                    }
                    catch (IOException e) {}
                }
                if (couldBeFound) continue;
                this.failedClasses.add(className);
                this.report(c);
                continue;
            }
            if (c instanceof MethodRefConstant || c instanceof InterfaceMethodRefConstant) {
                String className;
                t = this.getTypeInfo((TypedConstant)c);
                input = null;
                if (this.failedClasses.contains(t.ownerClass) || mcf.getMetaClass(className = t.ownerClass, false, false) instanceof ArrayMetaClass) continue;
                try {
                    input = this.classSource.openClass(className);
                    ClassFile cf = new ClassFile(input);
                    Collection methods = cf.getMethods();
                    for (ClassMethod m : methods) {
                        if (m.getName().equals(t.name) && m.getDescriptor().equals(t.type)) continue block39;
                    }
                }
                catch (NoClassDefFoundError e) {
                    this.report(c, new StringBuffer().append("The parent class, ").append(className).append(", could not be located.").toString());
                    continue;
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {}
                }
                if (this.file.getSuperClassName().equals(ClassLiteral.getClass("com/rc/retroweaver/runtime/Enum_").getName().replace('.', '/')) && t.name.equals("name") || t.name.equals("valueOf") && primitiveTypes.contains(t.ownerClass)) continue;
                this.report(c, new StringBuffer().append("Method not found in ").append(className).toString());
                continue;
            }
            if (!(c instanceof FieldRefConstant)) continue;
            t = this.getTypeInfo((TypedConstant)c);
            input = null;
            if (this.failedClasses.contains(t.ownerClass)) continue;
            try {
                input = this.classSource.openClass(t.ownerClass);
                ClassFile cf = new ClassFile(input);
                Collection fields = cf.getFields();
                for (ClassField f : fields) {
                    if (f.getName().equals(t.name) && f.getDescriptor().equals(t.type)) continue block39;
                }
            }
            catch (NoClassDefFoundError e) {
                this.report(c, new StringBuffer().append("The parent class, ").append(t.ownerClass).append(", could not be located.").toString());
                continue;
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {}
            }
            this.report(c, new StringBuffer().append("Field not found in ").append(t.ownerClass).toString());
        }
    }

    public TypeInfo getTypeInfo(TypedConstant c) {
        TypeInfo t = new TypeInfo();
        t.ownerClass = this.pool.getConstantAt(c.getClassIndex()).toString();
        int index = c.getNameAndTypeIndex();
        NameAndTypeConstant ntc = (NameAndTypeConstant)this.pool.getConstantAt(index);
        t.name = this.pool.getConstantAt(ntc.getNameIndex()).toString();
        t.type = this.pool.getConstantAt(ntc.getDescriptorIndex()).toString();
        return t;
    }

    private void report(Constant c) {
        this.report(c, null);
    }

    private void report(Constant c, String msg) {
        if (c instanceof ClassConstant) {
            this.report((ClassConstant)c, msg);
        } else if (c instanceof TypedConstant) {
            this.report((TypedConstant)c, msg);
        } else {
            throw new RuntimeException("Unexpected constant type");
        }
    }

    private void report(ClassConstant c, String msg) {
        String report = new StringBuffer().append("While processing, ").append(this.classfile).append(". Failed to find the class, ").append(c).append(", on the class path").toString();
        if (msg != null) {
            report = new StringBuffer().append(report).append(": ").append(msg).toString();
        }
        this.listener.acceptWarning(report);
    }

    private void report(TypedConstant c, String msg) {
        TypeInfo t = this.getTypeInfo(c);
        String type = c instanceof FieldRefConstant ? "field" : "method";
        String report = new StringBuffer().append("While processing, ").append(this.classfile).append(". Failed to find the ").append(type).append(", ").append(t.name).append("/").append(t.type).toString();
        if (msg != null) {
            report = new StringBuffer().append(report).append(", ").append(msg).toString();
        }
        this.listener.acceptWarning(report);
    }

    public static String getUsage() {
        return new StringBuffer().append("Usage: RefVerifier <options>").append(nl).append("  Options: ").append(nl).append(" -class <path to class to verify> (required) ").append(nl).append(" -cp <classpath containing valid classes> (required)").toString();
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> classpath = new ArrayList<String>();
        String classfile = null;
        for (int i = 0; i < args.length; ++i) {
            String command = args[i];
            ++i;
            if (command.equals("-class")) {
                classfile = args[i];
                continue;
            }
            if (command.equals("-cp")) {
                String path = args[i];
                StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    classpath.add(st.nextToken());
                }
                continue;
            }
            System.out.println(new StringBuffer().append("I don't understand the command: ").append(command).toString());
            System.out.println();
            System.out.println(RefVerifier.getUsage());
            return;
        }
        if (classfile == null) {
            System.out.println("Option \"-class\" is required.");
            System.out.println();
            System.out.println(RefVerifier.getUsage());
            return;
        }
        RefVerifier vr = new RefVerifier(classpath, new Listener(){

            public void verifyStarted(String msg) {
                System.out.println("[RefVerifier] " + msg);
            }

            public void acceptWarning(String msg) {
                System.out.println("[RefVerifier] " + msg);
            }
        });
        vr.verify(classfile);
    }

    static {
        primitiveTypes.add("java/lang/Boolean");
        primitiveTypes.add("java/lang/Byte");
        primitiveTypes.add("java/lang/Character");
        primitiveTypes.add("java/lang/Short");
        primitiveTypes.add("java/lang/Integer");
        primitiveTypes.add("java/lang/Float");
        primitiveTypes.add("java/lang/Long");
        primitiveTypes.add("java/lang/Double");
    }

    private static class TypeInfo {
        String ownerClass;
        String name;
        String type;

        private TypeInfo() {
        }
    }

    public static interface Listener {
        public void verifyStarted(String var1);

        public void acceptWarning(String var1);
    }
}

