/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import com.rc.retroweaver.RefVerifier;
import com.rc.retroweaver.RetroWeaver;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Weaver {
    public static final int VERSION_1_4 = 48;
    public static final int VERSION_1_3 = 47;
    public static final int VERSION_1_2 = 46;
    private static final String nl = System.getProperty("line.separator");

    public static void main(String[] args) {
        String source = null;
        int version = 48;
        int currentArg = 0;
        boolean lazy = false;
        String verifyPath = null;
        while (currentArg < args.length) {
            String command = args[currentArg];
            ++currentArg;
            if (command.equals("-source")) {
                source = args[currentArg++];
                continue;
            }
            if (command.equals("-version")) {
                String verStr;
                if ((verStr = args[currentArg++]).equals("1.4")) {
                    version = 48;
                    continue;
                }
                if (verStr.equals("1.3")) {
                    version = 47;
                    continue;
                }
                if (verStr.equals("1.2")) {
                    version = 46;
                    continue;
                }
                System.out.println("Invalid target version: " + verStr);
                System.out.println();
                System.out.println(Weaver.getUsage());
                return;
            }
            if (command.equals("-lazy")) {
                lazy = true;
                continue;
            }
            if (command.equals("-verifyRefs")) {
                verifyPath = args[currentArg++];
                continue;
            }
            System.out.println("I don't understand the command: " + command);
            System.out.println();
            System.out.println(Weaver.getUsage());
            return;
        }
        if (source == null) {
            System.out.println("Option \"-source\" is required.");
            System.out.println();
            System.out.println(Weaver.getUsage());
            return;
        }
        File sourcePath = new File(source);
        RetroWeaver weaver = new RetroWeaver(version);
        weaver.setLazy(lazy);
        try {
            Weaver.invokeWeaver(weaver, sourcePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Weaving failed", e);
        }
        if (verifyPath != null) {
            ArrayList<String> paths = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(verifyPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                paths.add(st.nextToken());
            }
            RefVerifier rv = new RefVerifier(paths, new RefVerifier.Listener(){

                public void verifyStarted(String msg) {
                    System.out.println("[RefVerifier] " + msg);
                }

                public void acceptWarning(String msg) {
                    System.out.println("[RefVerifier] " + msg);
                }
            });
            try {
                Weaver.invokeVerifier(rv, sourcePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Verification failed", e);
            }
        }
    }

    private static String getUsage() {
        return "Usage: Weaver <options>" + nl + "  Options: " + nl + " -source <source dir> (required)" + nl + " -version <target VM version> (one of {1.4, 1.3, 1.2}, default is 1.4)" + nl + " -verifyrefs <classpath>";
    }

    public static void invokeWeaver(RetroWeaver w, File path) throws Exception {
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".class");
            }
        };
        File[] files = path.listFiles(filter);
        if (files == null) {
            files = new File[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                Weaver.invokeWeaver(w, f);
                continue;
            }
            String pathStr = f.getCanonicalPath();
            w.weave(pathStr, null);
        }
    }

    public static void invokeVerifier(RefVerifier rv, File path) throws IOException {
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".class");
            }
        };
        File[] files = path.listFiles(filter);
        if (files == null) {
            files = new File[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                Weaver.invokeVerifier(rv, f);
                continue;
            }
            String pathStr = f.getCanonicalPath();
            rv.verify(pathStr);
        }
    }
}

