/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver.ant;

import com.rc.retroweaver.RefVerifier;
import com.rc.retroweaver.RetroWeaver;
import com.rc.retroweaver.event.WeaveListener;
import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class RetroWeaverTask
extends Task {
    private File itsDestDir;
    private boolean itsFailOnError = true;
    private List<FileSet> itsFileSets = new ArrayList<FileSet>();
    private boolean itsLazy = true;
    private boolean itsVerbose = false;
    private String refClassPath;
    private int itsVersion = 48;
    private static final Map<String, Integer> itsVersionMap = new HashMap<String, Integer>();

    public void setDestDir(File pDir) {
        if (!pDir.isDirectory()) {
            throw new BuildException("The destination directory doesn't exist: " + pDir, this.getLocation());
        }
        this.itsDestDir = pDir;
    }

    public void setFailOnError(boolean pFailOnError) {
        this.itsFailOnError = pFailOnError;
    }

    public void addFileSet(FileSet pFileSet) {
        this.itsFileSets.add(pFileSet);
    }

    public void setLazy(boolean pLazy) {
        this.itsLazy = pLazy;
    }

    public void setSrcDir(File pDir) {
        FileSet fileSet = new FileSet();
        fileSet.setDir(pDir);
        fileSet.setIncludes("**/*.class");
        this.addFileSet(fileSet);
    }

    public void setVerbose(boolean pVerbose) {
        this.itsVerbose = pVerbose;
    }

    public void setVersion(String pVersion) {
        Integer v = itsVersionMap.get(pVersion);
        if (v == null) {
            throw new BuildException("Unknown version: " + pVersion, this.getLocation());
        }
        this.itsVersion = v;
    }

    public void setVerifyRefs(String refClassPath) {
        this.refClassPath = refClassPath;
    }

    public void execute() throws BuildException {
        if (this.itsFileSets.size() == 0) {
            throw new BuildException("Either attribute 'srcdir' must be used or atleast one fileset must be embedded.", this.getLocation());
        }
        RetroWeaver weaver = new RetroWeaver(this.itsVersion);
        weaver.setLazy(this.itsLazy);
        if (this.itsVerbose) {
            weaver.setListener(new WeaveListener(){

                public void weavingPath(String pPath) {
                    RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, "Weaving " + pPath, 2);
                }
            });
        } else {
            weaver.setListener(null);
        }
        HashSet<String> weaved = new HashSet<String>();
        try {
            Iterator<FileSet> i$ = this.itsFileSets.iterator();
            while (i$.hasNext()) {
                FileSet fileSet = i$.next();
                File baseDir = fileSet.getDir(this.getProject());
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                String[] arr$ = scanner.getIncludedFiles();
                int len$ = arr$.length;
                for (int i$2 = 0; i$2 < len$; ++i$2) {
                    String fileName = arr$[i$2];
                    File file = new File(baseDir, fileName);
                    String sourcePath = file.getCanonicalPath();
                    String outputPath = null;
                    if (this.itsDestDir != null) {
                        outputPath = new File(this.itsDestDir, fileName).getCanonicalPath();
                    }
                    if (weaved.contains(sourcePath)) continue;
                    weaver.weave(sourcePath, outputPath);
                    weaved.add(sourcePath);
                }
            }
        }
        catch (Throwable ex) {
            if (this.itsFailOnError) {
                throw new BuildException(ex, this.getLocation());
            }
            this.getProject().log((Task)this, ex.toString(), 1);
        }
        if (this.refClassPath != null) {
            ArrayList<String> refPath = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.refClassPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                refPath.add(st.nextToken());
            }
            RefVerifier rv = new RefVerifier(refPath, new RefVerifier.Listener(){

                public void verifyStarted(String msg) {
                }

                public void acceptWarning(String msg) {
                    RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, msg, 1);
                }
            });
            Iterator<FileSet> i$ = this.itsFileSets.iterator();
            while (i$.hasNext()) {
                FileSet fileSet = i$.next();
                File baseDir = fileSet.getDir(this.getProject());
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                String[] arr$ = scanner.getIncludedFiles();
                int len$ = arr$.length;
                for (int i$3 = 0; i$3 < len$; ++i$3) {
                    String fileName = arr$[i$3];
                    File file = new File(baseDir, fileName);
                    try {
                        String sourcePath = file.getCanonicalPath();
                        rv.verify(sourcePath);
                        continue;
                    }
                    catch (Throwable ex) {
                        throw new BuildException(ex, this.getLocation());
                    }
                }
            }
        }
    }

    static {
        itsVersionMap.put("1.2", Autobox.valueOf(46));
        itsVersionMap.put("1.3", Autobox.valueOf(47));
        itsVersionMap.put("1.4", Autobox.valueOf(48));
        itsVersionMap.put("1.5", Autobox.valueOf(49));
    }
}

