/*
 * Decompiled with CFR 0.152.
 */
package ri.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheEntry;
import javax.cache.CacheEvictionStrategy;
import javax.cache.CacheException;
import javax.cache.CacheListener;
import javax.cache.CacheLoader;
import javax.cache.CacheStatistics;
import ri.cache.AsyncCacheWarmer;
import ri.cache.BestEffortStatistics;
import ri.cache.CacheListenerSupport;
import ri.cache.eviction.LRUChainEvictionStrategy;
import ri.cache.loader.NullCacheLoader;

public class BasicCache
extends AbstractMap
implements Cache {
    private static final int DEFAULT_TTL = -1;
    private static final int DEFAULT_CAPACITY = 100;
    protected final CacheLoader loader;
    protected final CacheEvictionStrategy evictionStrategy;
    protected final Map map = new ConcurrentHashMap();
    protected final long timeToLive;
    protected final int capacity;
    protected final CacheListenerSupport listeners = new CacheListenerSupport();
    protected final BestEffortStatistics statistics = new BestEffortStatistics();
    protected final AsyncCacheWarmer warmer = new AsyncCacheWarmer(this);
    protected Set entrySet;

    public BasicCache() {
        this(100);
    }

    public BasicCache(int capacity) {
        this(capacity, -1L);
    }

    public BasicCache(CacheLoader loader) {
        this(100, -1L, new LRUChainEvictionStrategy(), loader);
    }

    public BasicCache(int capacity, long timeToLive) {
        this(capacity, timeToLive, new LRUChainEvictionStrategy(), new NullCacheLoader());
    }

    public BasicCache(CacheEvictionStrategy evictionStrategy, CacheLoader loader) {
        this(100, -1L, evictionStrategy, loader);
    }

    public BasicCache(int capacity, long timeToLive, CacheEvictionStrategy evictionStrategy, CacheLoader loader) {
        this.loader = loader;
        this.evictionStrategy = evictionStrategy;
        this.timeToLive = timeToLive;
        this.capacity = capacity;
    }

    private static boolean isValid(CacheEntry ce) {
        return ce != null && ce.isValid();
    }

    protected Object putEntry(Object key, Object value) {
        CacheEntry ce;
        CacheEntry oldEntry;
        if (this.map.size() >= this.capacity) {
            this.evict();
        }
        if ((oldEntry = this.map.put(key, ce = this.evictionStrategy.createEntry(key, value, this.timeToLive))) != null) {
            this.evictionStrategy.discardEntry(oldEntry);
        }
        if (BasicCache.isValid(oldEntry)) {
            return oldEntry.getValue();
        }
        return null;
    }

    protected void loadEntry(Object key, Object value) {
        this.putEntry(key, value);
        this.listeners.onLoad(key);
    }

    public Object peek(Object key) {
        CacheEntry ce = this.getCacheEntry(key);
        return ce != null ? ce.getValue() : null;
    }

    public Object get(Object key) {
        CacheEntry ce = this.getCacheEntry(key);
        if (ce != null) {
            return ce.getValue();
        }
        Object o = null;
        try {
            o = this.loader.load(key);
        }
        catch (CacheException e) {
            // empty catch block
        }
        if (o != null) {
            this.loadEntry(key, o);
        }
        return o;
    }

    public Map getAll(Collection keys) throws CacheException {
        HashMap results = new HashMap(keys.size());
        ArrayList toLoad = new ArrayList();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            CacheEntry ce = this.getCacheEntry(key);
            if (ce != null) {
                results.put(ce.getKey(), ce.getValue());
                continue;
            }
            toLoad.add(key);
        }
        if (toLoad.size() > 0) {
            Map m = this.loader.loadAll(toLoad);
            Iterator i2 = m.keySet().iterator();
            while (i2.hasNext()) {
                Object key = i2.next();
                this.loadEntry(key, m.get(key));
            }
            results.putAll(m);
        }
        return results;
    }

    public void load(Object key) throws CacheException {
        this.warmer.load(key);
    }

    public void loadAll(Collection keys) throws CacheException {
        this.warmer.loadAll(keys);
    }

    public Object remove(Object key) {
        CacheEntry ce = (CacheEntry)this.map.remove(key);
        if (ce != null) {
            this.evictionStrategy.discardEntry(ce);
        }
        if (BasicCache.isValid(ce)) {
            this.listeners.onRemove(key);
            return ce.getValue();
        }
        return null;
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.putEntry(key, value);
        this.listeners.onPut(key);
        return oldValue;
    }

    public CacheEntry getCacheEntry(Object key) {
        CacheEntry ce = (CacheEntry)this.map.get(key);
        if (BasicCache.isValid(ce)) {
            this.evictionStrategy.touchEntry(ce);
            this.statistics.incrementHits();
            return ce;
        }
        if (ce != null) {
            this.evictionStrategy.discardEntry(ce);
        }
        this.statistics.incrementMisses();
        return null;
    }

    public boolean containsKey(Object key) {
        CacheEntry ce = this.getCacheEntry(key);
        return ce != null;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return BasicCache.this.map.values().iterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    return BasicCache.this.containsKey(entry.getKey());
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object old = BasicCache.this.remove(entry.getKey());
                    return old != null;
                }

                public int size() {
                    return BasicCache.this.size();
                }

                public void clear() {
                    BasicCache.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    public void evict() {
        Map m = this.evictionStrategy.evict(this);
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.map.remove(key);
            this.listeners.onEvict(key);
        }
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.statistics.clearStatistics();
        this.evictionStrategy.clear();
        this.map.clear();
        this.listeners.onClear();
    }

    public CacheStatistics getCacheStatistics() {
        return this.statistics;
    }

    public void addListener(CacheListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(CacheListener listener) {
        this.listeners.removeListener(listener);
    }
}

