/*
 * Decompiled with CFR 0.152.
 */
package ri.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheEntry;
import javax.cache.CacheException;
import javax.cache.CacheListener;
import javax.cache.CacheStatistics;
import ri.cache.AsyncCacheWarmer;
import ri.cache.BestEffortStatistics;
import ri.cache.CacheListenerSupport;

public class TieredCache
implements Cache {
    private final CacheListenerSupport listeners = new CacheListenerSupport();
    private final BestEffortStatistics statistics = new BestEffortStatistics();
    private final AsyncCacheWarmer warmer = new AsyncCacheWarmer(this);
    private final TieringStrategy strategy;
    private final Map L1;
    private final Map L2;

    public TieredCache(Map l1, Map l2) {
        this(l1, l2, new WriteThroughTieringStrategy(l2));
    }

    public TieredCache(Map l1, Map l2, TieringStrategy s) {
        this.L1 = l1;
        this.L2 = l2;
        this.strategy = s;
    }

    public Map getL1() {
        return this.L1;
    }

    public Map getL2() {
        return this.L2;
    }

    public boolean equals(Object o) {
        return ((Object)this.L1).equals(o);
    }

    public int hashCode() {
        return ((Object)this.L1).hashCode();
    }

    public int size() {
        return this.L1.size() + this.L2.size();
    }

    public boolean isEmpty() {
        if (!this.L1.isEmpty()) {
            return false;
        }
        return this.L2.isEmpty();
    }

    public Object get(Object key) {
        Object value = this.L1.get(key);
        if (value == null) {
            this.statistics.incrementMisses();
            value = this.L2.get(key);
            this.L1.put(key, value);
        } else {
            this.statistics.incrementHits();
        }
        return value;
    }

    public Map getAll(Collection keys) throws CacheException {
        HashMap results = new HashMap(keys.size());
        ArrayList toLoad = new ArrayList();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = this.L1.get(key);
            if (value == null) {
                this.statistics.incrementMisses();
                toLoad.add(key);
                continue;
            }
            this.statistics.incrementHits();
            results.put(key, value);
        }
        if (toLoad.size() > 0) {
            Map m;
            if (this.L2 instanceof Cache) {
                m = ((Cache)this.L2).getAll(toLoad);
            } else {
                m = new HashMap();
                Iterator i2 = toLoad.iterator();
                while (i2.hasNext()) {
                    Object key = i2.next();
                    m.put(key, this.L2.get(key));
                }
            }
            results.putAll(m);
            this.L1.putAll(m);
        }
        return results;
    }

    public void load(Object key) throws CacheException {
        this.warmer.load(key);
    }

    public void loadAll(Collection keys) throws CacheException {
        this.warmer.loadAll(keys);
    }

    public Object peek(Object key) {
        return this.getL1().get(key);
    }

    public CacheEntry getCacheEntry(Object key) {
        throw new UnsupportedOperationException();
    }

    public void evict() {
        throw new UnsupportedOperationException();
    }

    public CacheStatistics getCacheStatistics() {
        return this.statistics;
    }

    public void addListener(CacheListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(CacheListener listener) {
        this.listeners.addListener(listener);
    }

    public boolean containsKey(Object key) {
        return this.L1.containsKey(key) || this.L2.containsKey(key);
    }

    public Object put(Object key, Object value) {
        this.strategy.onPut(key, value);
        Object o = this.L1.put(key, value);
        this.listeners.onPut(key);
        return o;
    }

    public void putAll(Map t) {
        this.strategy.onPutAll(t);
        this.L1.putAll(t);
    }

    public Object remove(Object key) {
        this.strategy.onRemove(key);
        Object o = this.L1.remove(key);
        this.listeners.onRemove(key);
        return o;
    }

    public void clear() {
        this.strategy.onClear();
        this.L1.clear();
        this.listeners.onClear();
    }

    public boolean containsValue(Object value) {
        return this.L1.containsValue(value) || this.L2.containsValue(value);
    }

    public Set keySet() {
        HashSet s = new HashSet();
        s.addAll(this.L1.keySet());
        s.addAll(this.L2.keySet());
        return s;
    }

    public Collection values() {
        ArrayList l = new ArrayList();
        l.addAll(this.L1.values());
        l.addAll(this.L2.values());
        return l;
    }

    public Set entrySet() {
        HashSet s = new HashSet();
        s.addAll(this.L1.entrySet());
        s.addAll(this.L2.entrySet());
        return s;
    }

    public class ReadOnlyTieringStrategy
    implements TieringStrategy {
        public void onPut(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void onPutAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public void onRemove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void onClear() {
            throw new UnsupportedOperationException();
        }
    }

    public static class WriteThroughTieringStrategy
    implements TieringStrategy {
        private final Map target;

        public WriteThroughTieringStrategy(Map m) {
            this.target = m;
        }

        public void onRemove(Object key) {
            this.target.remove(key);
        }

        public void onPut(Object key, Object value) {
            this.target.put(key, value);
        }

        public void onPutAll(Map m) {
            this.target.putAll(m);
        }

        public void onClear() {
            this.target.clear();
        }
    }

    public static interface TieringStrategy {
        public void onPut(Object var1, Object var2);

        public void onPutAll(Map var1);

        public void onRemove(Object var1);

        public void onClear();
    }
}

