/*
 * Decompiled with CFR 0.152.
 */
package ri.cache.eviction;

import javax.cache.CacheEntry;

public abstract class AbstractCacheEntry
implements CacheEntry {
    private final Object key;
    private Object value;
    private int hitCount;
    private long lastAccessTime;
    private long version;
    private long lastUpdateTime;
    private final long creationTime;
    private final long ttl;

    public AbstractCacheEntry(Object key, Object value, long ttl) {
        long now;
        this.key = key;
        this.setValue(value);
        this.creationTime = now = System.currentTimeMillis();
        this.lastAccessTime = now;
        this.ttl = ttl;
    }

    public Object getKey() {
        return this.key;
    }

    public long getVersion() {
        return this.version;
    }

    public long getCost() {
        return 1L;
    }

    public boolean isValid() {
        return this.getExpirationTime() > System.currentTimeMillis();
    }

    public Object getValue() {
        return this.value;
    }

    public Object setValue(Object obj) {
        this.lastUpdateTime = System.currentTimeMillis();
        ++this.version;
        Object oldValue = this.value;
        this.value = obj;
        return oldValue;
    }

    public int getHits() {
        return this.hitCount;
    }

    public void touch() {
        this.lastAccessTime = System.currentTimeMillis();
        ++this.hitCount;
    }

    public abstract void discard();

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getExpirationTime() {
        if (this.ttl > 0L) {
            return this.lastUpdateTime + this.ttl;
        }
        return Long.MAX_VALUE;
    }

    public String toString() {
        return super.toString() + " - key: '" + this.key + "'";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractCacheEntry)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        CacheEntry other = (CacheEntry)obj;
        if (!this.isValid() || !other.isValid()) {
            return false;
        }
        Object otherValue = other.getValue();
        return this.value == otherValue || this.value != null && this.value.equals(otherValue);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

