/*
 * Decompiled with CFR 0.152.
 */
package ri.cache.eviction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheEntry;
import ri.cache.eviction.AbstractCacheEntry;
import ri.cache.eviction.AbstractEvictionStrategy;

public class BatchLRUEvictionStrategy
extends AbstractEvictionStrategy {
    private final int low;
    private final int timeout;

    public BatchLRUEvictionStrategy(int lowWaterMark, int idleTimeout) {
        this.low = lowWaterMark;
        this.timeout = idleTimeout;
    }

    public CacheEntry createEntry(Object key, Object value, long ttl) {
        return new Entry(key, value, ttl);
    }

    public Map evict(Cache c) {
        Entry e;
        ArrayList l = new ArrayList(c.entrySet());
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        Collections.sort(l, new EntryComparator());
        long now = System.currentTimeMillis();
        int i = l.size();
        while (--i >= 0 && ((e = (Entry)l.get(i)).getExpirationTime() > now || e.getLastAccessTime() + (long)this.timeout < now)) {
            l.remove(i);
            m.put(e.getKey(), e.getValue());
        }
        i = l.size();
        while (--i >= this.low) {
            e = (Entry)l.remove(i);
            m.put(e.getKey(), e.getValue());
        }
        return m;
    }

    private static class Entry
    extends AbstractCacheEntry {
        public Entry(Object key, Object value, long ttl) {
            super(key, value, ttl);
        }

        public void discard() {
        }
    }

    public class EntryComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Entry e1 = (Entry)o1;
            Entry e2 = (Entry)o2;
            long now = System.currentTimeMillis();
            if (e1.getExpirationTime() > now && e2.getExpirationTime() <= now) {
                return -1;
            }
            if (e2.getExpirationTime() > now && e1.getExpirationTime() <= now) {
                return 1;
            }
            if (e1.getExpirationTime() > now && e2.getExpirationTime() > now) {
                return 0;
            }
            long idleTime = now - (long)BatchLRUEvictionStrategy.this.timeout;
            if (e1.getLastAccessTime() > idleTime && e2.getLastAccessTime() <= idleTime) {
                return -1;
            }
            if (e2.getLastAccessTime() > idleTime && e1.getLastAccessTime() <= idleTime) {
                return 1;
            }
            if (e1.getLastAccessTime() > idleTime && e2.getLastAccessTime() > idleTime) {
                return 0;
            }
            long diff = e2.getLastAccessTime() - e1.getLastAccessTime();
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

