/*
 * Decompiled with CFR 0.152.
 */
package ri.cache.eviction;

import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheEntry;
import ri.cache.eviction.AbstractCacheEntry;
import ri.cache.eviction.AbstractEvictionStrategy;

public class LRUChainEvictionStrategy
extends AbstractEvictionStrategy {
    protected Entry header;

    public LRUChainEvictionStrategy() {
        this.header.next = this.header.previous = (this.header = new Entry(null, null, -1L));
    }

    public CacheEntry createEntry(Object key, Object value, long ttl) {
        Entry e = new Entry(key, value, ttl);
        e.addFirst();
        return e;
    }

    public Map evict(Cache c) {
        Entry last = this.header.previous;
        last.discard();
        HashMap<Object, Object> m = new HashMap<Object, Object>(1);
        m.put(last.getKey(), last.getValue());
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Entry entry = this.header;
        synchronized (entry) {
            this.header.next = null;
            this.header.previous = null;
        }
    }

    protected class Entry
    extends AbstractCacheEntry {
        protected Entry next;
        protected Entry previous;

        public Entry(Object key, Object value, long ttl) {
            super(key, value, ttl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFirst() {
            Entry entry = LRUChainEvictionStrategy.this.header;
            synchronized (entry) {
                this.next = LRUChainEvictionStrategy.this.header.next;
                this.previous = LRUChainEvictionStrategy.this.header;
                LRUChainEvictionStrategy.this.header.next = this;
                this.next.previous = this;
            }
        }

        public void touch() {
            this.discard();
            this.addFirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discard() {
            Entry entry = LRUChainEvictionStrategy.this.header;
            synchronized (entry) {
                this.previous.next = this.next;
                this.next.previous = this.previous;
            }
        }
    }
}

