/*
 * Decompiled with CFR 0.152.
 */
package ri.cache.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.cache.CacheLoader;
import javax.cache.CacheLoaderContext;
import javax.cache.CacheLoaderException;
import ri.cache.loader.AbstractCacheLoader;

public class FileLoader
extends AbstractCacheLoader
implements CacheLoader {
    private final File rootDirectory;

    public FileLoader(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public FileLoader(String rootDirectory) {
        this.rootDirectory = new File(rootDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Object key) throws CacheLoaderException {
        byte[] byArray;
        File f = new File(this.rootDirectory, (String)key);
        long length = f.length();
        if (length > Integer.MAX_VALUE) {
            throw new CacheLoaderException("FileLoader: file is too long");
        }
        FileInputStream is = new FileInputStream(f);
        try {
            byte[] bytes = new byte[(int)length];
            ((InputStream)is).read(bytes);
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new CacheLoaderException("IOException reading file " + f.getAbsolutePath(), e);
            }
        }
        ((InputStream)is).close();
        return byArray;
    }

    public void setContext(CacheLoaderContext ctx) {
    }

    public void unsetContext() {
    }
}

