/*
 * Decompiled with CFR 0.152.
 */
package ri.cache.maps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import ri.cache.maps.AbstractLoaderMap;

public class FileLoaderMap
extends AbstractLoaderMap {
    private final File rootDirectory;

    public FileLoaderMap(String directory) {
        this(new File(directory));
    }

    public FileLoaderMap(File directory) {
        this.rootDirectory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        byte[] byArray;
        File f = new File(this.rootDirectory, (String)key);
        long length = f.length();
        if (length > Integer.MAX_VALUE) {
            throw new RuntimeException("FileLoader: file is too long");
        }
        FileInputStream is = new FileInputStream(f);
        try {
            byte[] bytes = new byte[(int)length];
            ((InputStream)is).read(bytes);
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("IOException reading file " + f.getAbsolutePath(), e);
            }
        }
        ((InputStream)is).close();
        return byArray;
    }
}

