/*
 * Decompiled with CFR 0.152.
 */
package ri.cache.transport;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import ri.cache.transport.TransportEndpoint;
import ri.cache.transport.TransportEndpointFactory;
import ri.cache.transport.TransportException;
import ri.cache.transport.TransportListener;
import ri.cache.transport.events.CacheEvent;
import ri.cache.transport.events.CacheRequest;
import ri.cache.transport.events.CacheResponse;

public class LocalTransportFactory
implements TransportEndpointFactory {
    public static final String ENDPOINT_NAME = "ENDPOINT_NAME";
    private Map endpointMap = new ConcurrentHashMap();
    private static LocalTransportFactory instance = new LocalTransportFactory();

    private LocalTransportFactory() {
    }

    public static synchronized LocalTransportFactory getFactory() {
        return instance;
    }

    public TransportEndpoint getEndpoint(Map parameters) throws TransportException {
        String name = (String)parameters.get(ENDPOINT_NAME);
        if (name == null) {
            throw new TransportException("ENDPOINT_NAME parameter required for LocalTransportFactory.getEndpoint");
        }
        return new LocalTransportEndpoint(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(Map parameters, TransportListener listener) throws TransportException {
        String name = (String)parameters.get(ENDPOINT_NAME);
        if (name == null) {
            throw new TransportException("ENDPOINT_NAME parameter required for LocalTransportFactory.getEndpoint");
        }
        LocalTransportFactory localTransportFactory = this;
        synchronized (localTransportFactory) {
            TransportListener existingListener = (TransportListener)this.endpointMap.get(name);
            if (existingListener != null) {
                throw new TransportException("Endpoint already registered; name=" + name);
            }
            this.endpointMap.put(name, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(Map parameters, TransportListener listener) throws TransportException {
        String name = (String)parameters.get(ENDPOINT_NAME);
        if (name == null) {
            throw new TransportException("ENDPOINT_NAME parameter required for LocalTransportFactory.getEndpoint");
        }
        LocalTransportFactory localTransportFactory = this;
        synchronized (localTransportFactory) {
            TransportListener existingListener = (TransportListener)this.endpointMap.get(name);
            if (existingListener == null) {
                throw new TransportException("Endpoint not registered; name=" + name);
            }
            if (existingListener != listener) {
                throw new TransportException("Endpoint registered with different listener; name=" + name);
            }
            this.endpointMap.remove(name);
        }
    }

    public class LocalTransportEndpoint
    implements TransportEndpoint {
        private final String name;

        public LocalTransportEndpoint(String name) {
            this.name = name;
        }

        private TransportListener getListener() throws TransportException {
            TransportListener listener = (TransportListener)LocalTransportFactory.this.endpointMap.get(this.name);
            if (listener == null) {
                throw new TransportException("Unable to find local transport listener; name=" + this.name);
            }
            return listener;
        }

        public void sendCacheEvent(CacheEvent e) throws TransportException {
            TransportListener listener = this.getListener();
            listener.onCacheEvent(e);
        }

        public CacheResponse sendCacheRequest(CacheRequest e) throws TransportException {
            TransportListener listener = this.getListener();
            return listener.onCacheRequest(e);
        }
    }
}

