/*
 * Decompiled with CFR 0.152.
 */
package ri.cache.transport;

import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import ri.cache.transport.TransportEndpoint;
import ri.cache.transport.TransportEndpointFactory;
import ri.cache.transport.TransportException;
import ri.cache.transport.TransportListener;
import ri.cache.transport.events.CacheEvent;
import ri.cache.transport.events.CacheRequest;
import ri.cache.transport.events.CacheResponse;

public class RmiTransportFactory
implements TransportEndpointFactory {
    public static final String HOST_NAME = "HOST_NAME";
    public static final String HOST_PORT = "HOST_PORT";
    public static final String ENTITY_NAME = "ENTITY_NAME";
    private static RmiTransportFactory instance = new RmiTransportFactory();

    private RmiTransportFactory() {
    }

    public static synchronized RmiTransportFactory getFactory() {
        return instance;
    }

    private String getNameString(Map parameters) throws TransportException {
        String hostName = (String)parameters.get(HOST_NAME);
        String hostPort = (String)parameters.get(HOST_PORT);
        String entityName = (String)parameters.get(ENTITY_NAME);
        if (entityName == null) {
            throw new TransportException("ENTITY_NAME parameter required for RmiTransportFactory.getEndpoint");
        }
        StringBuffer sb = new StringBuffer("//");
        sb.append(hostName != null ? hostName : "localhost");
        if (hostPort != null) {
            sb.append(":");
            sb.append(hostPort);
        }
        sb.append("/");
        sb.append(entityName);
        return sb.toString();
    }

    public TransportEndpoint getEndpoint(Map parameters) throws TransportException {
        return new RmiTransportEndpoint(this.getNameString(parameters));
    }

    public void registerListener(Map parameters, TransportListener listener) throws TransportException {
        String name = this.getNameString(parameters);
        try {
            RemoteListenerAdapter remoteListener = new RemoteListenerAdapter(listener);
            Naming.bind(name, remoteListener);
        }
        catch (AlreadyBoundException e) {
            throw new TransportException("RMI listener already registered: " + name, e);
        }
        catch (MalformedURLException e) {
            throw new TransportException("Invalid RMI name: " + name, e);
        }
        catch (RemoteException e) {
            throw new TransportException("RemoteException binding RMI listener: " + name, e);
        }
    }

    public void unregisterListener(Map parameters, TransportListener listener) throws TransportException {
    }

    private static class RmiTransportEndpoint
    implements TransportEndpoint {
        private final String nameString;
        private volatile RemoteTransportListener stub;

        public RmiTransportEndpoint(String nameString) {
            this.nameString = nameString;
        }

        private void findStub() throws TransportException {
            try {
                if (this.stub == null) {
                    this.stub = (RemoteTransportListener)Naming.lookup(this.nameString);
                }
            }
            catch (NotBoundException e) {
                throw new TransportException("RMI listener not registered: " + this.nameString, e);
            }
            catch (MalformedURLException e) {
                throw new TransportException("Invalid RMI name: " + this.nameString, e);
            }
            catch (RemoteException e) {
                throw new TransportException("RemoteException looking up RMI listener: " + this.nameString, e);
            }
        }

        public void sendCacheEvent(CacheEvent event) throws TransportException {
            this.findStub();
            try {
                this.stub.onCacheEvent(event);
            }
            catch (RemoteException e) {
                throw new TransportException("RemoteException invoking RMI listener: " + this.nameString, e);
            }
        }

        public CacheResponse sendCacheRequest(CacheRequest req) throws TransportException {
            this.findStub();
            try {
                return this.stub.onCacheRequest(req);
            }
            catch (RemoteException e) {
                throw new TransportException("RemoteException invoking RMI listener: " + this.nameString, e);
            }
        }
    }

    public static class RemoteListenerAdapter
    extends UnicastRemoteObject
    implements RemoteTransportListener {
        private final TransportListener listener;

        public RemoteListenerAdapter(TransportListener listener) throws RemoteException {
            this.listener = listener;
        }

        public void onCacheEvent(CacheEvent e) throws RemoteException {
            this.listener.onCacheEvent(e);
        }

        public CacheResponse onCacheRequest(CacheRequest req) throws RemoteException {
            return this.listener.onCacheRequest(req);
        }
    }

    public static interface RemoteTransportListener
    extends Remote {
        public void onCacheEvent(CacheEvent var1) throws RemoteException;

        public CacheResponse onCacheRequest(CacheRequest var1) throws RemoteException;
    }
}

