/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.nlp.categorisation;

import ae.teletronics.nlp.categorisation.Categoriser;
import ae.teletronics.nlp.categorisation.Category;
import ae.teletronics.nlp.categorisation.Levenshtein$;
import java.util.List;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u0017\t\u0001b)\u001e>{s\u000e\u000bG/Z4pe&\u001cXM\u001d\u0006\u0003\u0007\u0011\tabY1uK\u001e|'/[:bi&|gN\u0003\u0002\u0006\r\u0005\u0019a\u000e\u001c9\u000b\u0005\u001dA\u0011a\u0003;fY\u0016$(o\u001c8jGNT\u0011!C\u0001\u0003C\u0016\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\f\u0007\u0006$XmZ8sSN,'\u000f\u0003\u0005\u0012\u0001\t\u0005\t\u0015!\u0003\u0013\u0003)\u0019\u0017\r^3h_JLWm\u001d\t\u0004'aQR\"\u0001\u000b\u000b\u0005U1\u0012\u0001B;uS2T\u0011aF\u0001\u0005U\u00064\u0018-\u0003\u0002\u001a)\t!A*[:u!\ti1$\u0003\u0002\u001d\u0005\tA1)\u0019;fO>\u0014\u0018\u0010\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0001 \u0003-i\u0017\r\u001f#jgR\fgnY3\u0016\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121!\u00138u\u0011!9\u0003A!A!\u0002\u0013\u0001\u0013\u0001D7bq\u0012K7\u000f^1oG\u0016\u0004\u0003\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\u0002G5\f\u0007\u0010R5ti\u0006t7-Z!t!\u0016\u00148-\u001a8uC\u001e,wJZ,pe\u0012dUM\\4uQV\t1\u0006\u0005\u0002\"Y%\u0011QF\t\u0002\u0007\t>,(\r\\3\t\u0011=\u0002!\u0011!Q\u0001\n-\nA%\\1y\t&\u001cH/\u00198dK\u0006\u001b\b+\u001a:dK:$\u0018mZ3PM^{'\u000f\u001a'f]\u001e$\b\u000e\t\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM\"TG\u000e\t\u0003\u001b\u0001AQ!\u0005\u0019A\u0002IAQA\b\u0019A\u0002\u0001BQ!\u000b\u0019A\u0002-BQ\u0001\u000f\u0001\u0005\u0002e\nq![:NCR\u001c\u0007\u000eF\u0002;{\u0019\u0003\"!I\u001e\n\u0005q\u0012#a\u0002\"p_2,\u0017M\u001c\u0005\u0006}]\u0002\raP\u0001\u0006o>\u0014H-\r\t\u0003\u0001\u000es!!I!\n\u0005\t\u0013\u0013A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!A\u0011\u0012\t\u000b\u001d;\u0004\u0019A \u0002\u000b]|'\u000f\u001a\u001a\t\u000b%\u0003A\u0011\t&\u0002+\r\fG/Z4pe&\u001cXM\u001d)be\u0006lW\r^3sgV\t1\n\u0005\u0003A\u0019~z\u0014BA'F\u0005\ri\u0015\r\u001d")
public class FuzzyCategoriser
extends Categoriser {
    private final int maxDistance;
    private final double maxDistanceAsPercentageOfWordLength;

    public int maxDistance() {
        return this.maxDistance;
    }

    public double maxDistanceAsPercentageOfWordLength() {
        return this.maxDistanceAsPercentageOfWordLength;
    }

    @Override
    public boolean isMatch(String word1, String word2) {
        int distance2 = Levenshtein$.MODULE$.distance(word1, word2);
        boolean term0 = distance2 <= this.maxDistance();
        boolean term1 = (double)distance2 / (double)word1.length() <= this.maxDistanceAsPercentageOfWordLength();
        boolean term2 = (double)distance2 / (double)word2.length() <= this.maxDistanceAsPercentageOfWordLength();
        return term0 && term1 && term2;
    }

    @Override
    public Map<String, String> categoriserParameters() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"MaxDistance", (Object)((Object)BoxesRunTime.boxToInteger((int)this.maxDistance())).toString()), new Tuple2((Object)"maxDistanceAsPercentageOfWordLength", (Object)((Object)BoxesRunTime.boxToDouble((double)this.maxDistanceAsPercentageOfWordLength())).toString())}));
    }

    public FuzzyCategoriser(List<Category> categories2, int maxDistance, double maxDistanceAsPercentageOfWordLength) {
        this.maxDistance = maxDistance;
        this.maxDistanceAsPercentageOfWordLength = maxDistanceAsPercentageOfWordLength;
        super(categories2);
    }
}

