/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.nlp.categorisation;

import ae.teletronics.nlp.categorisation.EntryParseResult;
import ae.teletronics.nlp.categorisation.FuzzyMatcher;
import ae.teletronics.nlp.categorisation.Matcher;
import ae.teletronics.nlp.categorisation.RegexMatcher;
import ae.teletronics.nlp.categorisation.StrictMatcher;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class EntryParser$ {
    public static final EntryParser$ MODULE$;
    private final RegexMatcher regexMatcher;
    private final FuzzyMatcher fuzzyMatcher;
    private final StrictMatcher strictMatcher;
    private final Regex signifierParser;

    static {
        new EntryParser$();
    }

    public RegexMatcher regexMatcher() {
        return this.regexMatcher;
    }

    public FuzzyMatcher fuzzyMatcher() {
        return this.fuzzyMatcher;
    }

    public StrictMatcher strictMatcher() {
        return this.strictMatcher;
    }

    public Regex signifierParser() {
        return this.signifierParser;
    }

    public EntryParseResult parse(String entry) {
        Tuple2 tuple2;
        Regex.Match matchResult = (Regex.Match)this.signifierParser().findFirstMatchIn((CharSequence)entry).get();
        String signifier = matchResult.group(1);
        String entryWithLabel = matchResult.group(2);
        if (entryWithLabel.contains("/")) {
            int lastSlash = entryWithLabel.lastIndexOf("/");
            String exactEntryPart = entryWithLabel.substring(0, lastSlash);
            String labelPart = entryWithLabel.substring(lastSlash + 1);
            tuple2 = new Tuple2((Object)exactEntryPart, (Object)labelPart);
        } else {
            tuple2 = new Tuple2((Object)entryWithLabel, (Object)entryWithLabel);
        }
        Tuple2 exactEntryAndLabel = tuple2;
        String exactEntry = (String)exactEntryAndLabel._1();
        String label = (String)exactEntryAndLabel._2();
        String string = signifier;
        Matcher matcher = "/".equals(string) ? this.regexMatcher() : ("~".equals(string) ? this.fuzzyMatcher() : this.strictMatcher());
        RegexMatcher matcher2 = matcher;
        return new EntryParseResult(matcher2, label, exactEntry);
    }

    private EntryParser$() {
        MODULE$ = this;
        this.regexMatcher = new RegexMatcher();
        this.fuzzyMatcher = new FuzzyMatcher(2, 0.15);
        this.strictMatcher = new StrictMatcher();
        this.signifierParser = new StringOps(Predef$.MODULE$.augmentString("^([~/]?)(.*)$")).r();
    }
}

