/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.mediation;

import ae.trdqad.base.Logger;
import ae.trdqad.mediation.MBridgeURL;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.publicsuffix.PublicSuffixDatabase;
import com.mbridge.msdk.thrid.okio.Buffer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class MBHttpUrl {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    final String scheme;
    private final String username;
    private final String password;
    final String host;
    final int port;
    private final List<String> pathSegments;
    private final List<String> queryNamesAndValues;
    private final String fragment;
    private final String url;

    /*
     * WARNING - void declaration
     */
    public MBHttpUrl(Builder builder) {
        void var1_1;
        this.scheme = var1_1.scheme;
        this.username = MBHttpUrl.percentDecode(var1_1.encodedUsername, false);
        this.password = MBHttpUrl.percentDecode(var1_1.encodedPassword, false);
        this.host = var1_1.host;
        this.port = var1_1.effectivePort();
        this.pathSegments = this.percentDecode(var1_1.encodedPathSegments, false);
        Object object = builder.encodedQueryNamesAndValues;
        object = object != null ? this.percentDecode((List<String>)object, true) : null;
        this.queryNamesAndValues = object;
        object = var1_1.encodedFragment;
        object = object != null ? MBHttpUrl.percentDecode((String)object, false) : null;
        this.fragment = object;
        this.url = var1_1.toString();
    }

    public static int defaultPort(String scheme) {
        String string;
        if (scheme.equals("http")) {
            return 80;
        }
        return string.equals("https") ? 443 : -1;
    }

    /*
     * WARNING - void declaration
     */
    public static void pathSegmentsToString(StringBuilder out, List<String> pathSegments) {
        int n2 = pathSegments.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            StringBuilder stringBuilder;
            stringBuilder.append('/');
            stringBuilder.append((String)var1_1.get(i2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void namesAndValuesToQueryString(StringBuilder out, List<String> namesAndValues) {
        int n2 = namesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            StringBuilder stringBuilder;
            void var1_1;
            String string = (String)var1_1.get(i2);
            String string2 = (String)var1_1.get(i2 + 1);
            if (i2 > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string);
            if (string2 == null) continue;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append('=');
            stringBuilder2.append(string2);
        }
    }

    public static List<String> queryStringToNamesAndValues(String encodedQuery) {
        String string;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 <= string.length()) {
            int n3;
            int n4 = string.indexOf(38, n2);
            if (n4 == -1) {
                n4 = string.length();
            }
            if ((n3 = string.indexOf(61, n2)) != -1 && n3 <= n4) {
                arrayList2.add(string.substring(n2, n3));
                arrayList2.add(string.substring(n3 + 1, n4));
            } else {
                ArrayList<String> arrayList3 = arrayList2;
                arrayList3.add(string.substring(n2, n4));
                arrayList3.add(null);
            }
            n2 = n4 + 1;
        }
        return arrayList2;
    }

    public static MBHttpUrl parse(String url) {
        try {
            return MBHttpUrl.get(url);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static MBHttpUrl get(String url) {
        String string;
        return new Builder().parse(null, string).build();
    }

    public static MBHttpUrl get(URL url) {
        return MBHttpUrl.parse(url.toString());
    }

    public static MBHttpUrl get(URI uri) {
        return MBHttpUrl.parse(uri.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static String percentDecode(String encoded, boolean plusIsSpace) {
        void var1_1;
        String string = encoded;
        return MBHttpUrl.percentDecode(string, 0, string.length(), (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> percentDecode(List<String> list, boolean plusIsSpace) {
        ArrayList<String> arrayList;
        int n2 = list.size();
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            void var2_3;
            void var1_2;
            String string = (String)var1_2.get(i2);
            string = string != null ? MBHttpUrl.percentDecode(string, (boolean)var2_3) : null;
            arrayList2.add(string);
        }
        return Collections.unmodifiableList(arrayList2);
    }

    /*
     * WARNING - void declaration
     */
    public static String percentDecode(String encoded, int pos, int limit, boolean plusIsSpace) {
        void var1_1;
        String string;
        void var2_2;
        for (int i2 = pos; i2 < var2_2; ++i2) {
            Buffer buffer;
            void var3_3;
            char c2 = string.charAt(i2);
            if (c2 != '%' && (c2 != '+' || var3_3 == false)) {
                continue;
            }
            Buffer buffer2 = buffer;
            buffer2();
            buffer2.writeUtf8(string, (int)var1_1, i2);
            MBHttpUrl.percentDecode(buffer, string, i2, (int)var2_2, (boolean)var3_3);
            return buffer.readUtf8();
        }
        return string.substring((int)var1_1, (int)var2_2);
    }

    /*
     * Unable to fully structure code
     */
    public static void percentDecode(Buffer out, String encoded, int pos, int limit, boolean plusIsSpace) {
        while (pos < var3_3) {
            block4: {
                block3: {
                    var5_5 = var1_1.codePointAt((int)var2_2);
                    if (var5_5 != 37 || (var6_6 = var2_2 + 2) >= var3_3) break block3;
                    var7_7 = Util.decodeHexDigit((char)var1_1.charAt((int)(var2_2 + true)));
                    var8_8 = Util.decodeHexDigit((char)var1_1.charAt((int)var6_6));
                    if (var7_7 == -1 || var8_8 == -1) ** GOTO lbl-1000
                    var0.writeByte((var7_7 << 4) + var8_8);
                    var2_2 = var6_6;
                    break block4;
                }
                if (var5_5 == 43 && var4_4 != false) {
                    var0.writeByte(32);
                } else lbl-1000:
                // 2 sources

                {
                    var0.writeUtf8CodePoint(var5_5);
                }
            }
            var2_2 += Character.charCount(var5_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean percentEncoded(String encoded, int pos, int limit) {
        void var1_1;
        String string;
        void var2_2;
        int n2 = pos + 2;
        return n2 < var2_2 && string.charAt((int)var1_1) == '%' && Util.decodeHexDigit((char)string.charAt((int)(var1_1 + true))) != -1 && Util.decodeHexDigit((char)string.charAt(n2)) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static String canonicalize(String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        void var1_1;
        String string;
        void var2_2;
        int n2;
        for (int i2 = pos; i2 < var2_2; i2 += Character.charCount(n2)) {
            void var8_8;
            Buffer buffer;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var7_7;
            n2 = string.codePointAt(i2);
            if (!(n2 < 32 || n2 == 127 || n2 >= 128 && var7_7 != false || var3_3.indexOf(n2) != -1 || n2 == 37 && (var4_4 == false || var5_5 != false && !MBHttpUrl.percentEncoded(string, i2, (int)var2_2)) || n2 == 43 && var6_6 != false)) {
                continue;
            }
            Buffer buffer2 = buffer;
            buffer2();
            buffer2.writeUtf8(string, (int)var1_1, i2);
            MBHttpUrl.canonicalize(buffer, string, i2, (int)var2_2, (String)var3_3, (boolean)var4_4, (boolean)var5_5, (boolean)var6_6, (boolean)var7_7, (Charset)var8_8);
            return buffer.readUtf8();
        }
        return string.substring((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void canonicalize(Buffer out, String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        void var3_3;
        void var2_2;
        Buffer buffer = null;
        while (var2_2 < var3_3) {
            void var5_5;
            void var1_1;
            int n2 = var1_1.codePointAt((int)var2_2);
            if (var5_5 == false || n2 != 9 && n2 != 10 && n2 != 12 && n2 != 13) {
                void var6_6;
                void var4_4;
                void var8_8;
                Buffer buffer2;
                void var7_7;
                if (n2 == 43 && var7_7 != false) {
                    String string = var5_5 != false ? "+" : "%2B";
                    buffer2.writeUtf8(string);
                } else if (!(n2 < 32 || n2 == 127 || n2 >= 128 && var8_8 != false || var4_4.indexOf(n2) != -1 || n2 == 37 && (var5_5 == false || var6_6 != false && !MBHttpUrl.percentEncoded((String)var1_1, (int)var2_2, (int)var3_3)))) {
                    buffer2.writeUtf8CodePoint(n2);
                } else {
                    void var9_9;
                    if (buffer == null) {
                        Buffer buffer3;
                        buffer = buffer3;
                        buffer3 = new Buffer();
                    }
                    if (var9_9 != null && !var9_9.equals(Util.UTF_8)) {
                        buffer.writeString((String)var1_1, (int)var2_2, (int)(var2_2 + Character.charCount(n2)), (Charset)var9_9);
                    } else {
                        buffer.writeUtf8CodePoint(n2);
                    }
                    while (!buffer.exhausted()) {
                        Buffer buffer4 = buffer2;
                        byte by = buffer.readByte();
                        int n3 = by & 0xFF;
                        buffer4.writeByte(37);
                        char[] cArray = HEX_DIGITS;
                        buffer2.writeByte((int)cArray[n3 >> 4 & 0xF]);
                        buffer4.writeByte((int)HEX_DIGITS[by & 0xF]);
                    }
                }
            }
            var2_2 += Character.charCount(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        String string = input;
        return MBHttpUrl.canonicalize(string, 0, string.length(), (String)var1_1, (boolean)var2_2, (boolean)var3_3, (boolean)var4_4, (boolean)var5_5, (Charset)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    public static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        String string = input;
        return MBHttpUrl.canonicalize(string, 0, string.length(), (String)var1_1, (boolean)var2_2, (boolean)var3_3, (boolean)var4_4, (boolean)var5_5, null);
    }

    public MBridgeURL url() {
        Logger.INSTANCE.d("url using url() method: " + this.url);
        try {
            return new MBridgeURL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public URI uri() {
        Object object;
        try {
            object = new MBridgeURL(((MBHttpUrl)object).newBuilder().reencodeForUri().toString()).toString();
        }
        catch (MalformedURLException malformedURLException) {
            object = ((MBHttpUrl)object).newBuilder().reencodeForUri().toString();
        }
        Logger.INSTANCE.d("url using uri() method: " + (String)object);
        try {
            return new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                return URI.create(((String)object).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]", ""));
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public String scheme() {
        return this.scheme;
    }

    public boolean isHttps() {
        return this.scheme.equals("https");
    }

    public String encodedUsername() {
        if (this.username.isEmpty()) {
            return "";
        }
        MBHttpUrl mBHttpUrl = this;
        int n2 = mBHttpUrl.scheme.length() + 3;
        String string = mBHttpUrl.url;
        int n3 = Util.delimiterOffset((String)string, (int)n2, (int)string.length(), (String)":@");
        return mBHttpUrl.url.substring(n2, n3);
    }

    public String username() {
        return this.username;
    }

    public String encodedPassword() {
        if (this.password.isEmpty()) {
            return "";
        }
        MBHttpUrl mBHttpUrl = this;
        int n2 = mBHttpUrl.url.indexOf(58, this.scheme.length() + 3) + 1;
        int n3 = mBHttpUrl.url.indexOf(64);
        return mBHttpUrl.url.substring(n2, n3);
    }

    public String password() {
        return this.password;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int pathSize() {
        return this.pathSegments.size();
    }

    public String encodedPath() {
        MBHttpUrl mBHttpUrl = this;
        int n2 = mBHttpUrl.url.indexOf(47, this.scheme.length() + 3);
        String string = mBHttpUrl.url;
        int n3 = Util.delimiterOffset((String)string, (int)n2, (int)string.length(), (String)"?#");
        return mBHttpUrl.url.substring(n2, n3);
    }

    public List<String> encodedPathSegments() {
        ArrayList<String> arrayList;
        MBHttpUrl mBHttpUrl = this;
        int n2 = mBHttpUrl.url.indexOf(47, this.scheme.length() + 3);
        String string = mBHttpUrl.url;
        int n3 = Util.delimiterOffset((String)string, (int)n2, (int)string.length(), (String)"?#");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        while (n2 < n3) {
            MBHttpUrl mBHttpUrl2 = this;
            int n4 = Util.delimiterOffset((String)mBHttpUrl2.url, (int)(++n2), (int)n3, (char)'/');
            arrayList2.add(mBHttpUrl2.url.substring(n2, n4));
            n2 = n4;
        }
        return arrayList2;
    }

    public List<String> pathSegments() {
        return this.pathSegments;
    }

    public String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        MBHttpUrl mBHttpUrl = this;
        int n2 = mBHttpUrl.url.indexOf(63) + 1;
        String string = mBHttpUrl.url;
        int n3 = Util.delimiterOffset((String)string, (int)n2, (int)string.length(), (char)'#');
        return mBHttpUrl.url.substring(n2, n3);
    }

    public String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        MBHttpUrl.namesAndValuesToQueryString(stringBuilder, this.queryNamesAndValues);
        return stringBuilder.toString();
    }

    public int querySize() {
        List<String> this_ = ((MBHttpUrl)((Object)this_)).queryNamesAndValues;
        return this_ != null ? this_.size() / 2 : 0;
    }

    /*
     * WARNING - void declaration
     */
    public String queryParameter(String name) {
        List<String> list = this.queryNamesAndValues;
        if (list == null) {
            return null;
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            void var1_1;
            if (!var1_1.equals(this.queryNamesAndValues.get(i2))) continue;
            return this.queryNamesAndValues.get(i2 + 1);
        }
        return null;
    }

    public Set<String> queryParameterNames() {
        LinkedHashSet<String> linkedHashSet;
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet2 = linkedHashSet;
        linkedHashSet = new LinkedHashSet<String>();
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            linkedHashSet2.add(this.queryNamesAndValues.get(i2));
        }
        return Collections.unmodifiableSet(linkedHashSet2);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> queryParameterValues(String name) {
        ArrayList<String> arrayList;
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            void var1_1;
            if (!var1_1.equals(this.queryNamesAndValues.get(i2))) continue;
            arrayList2.add(this.queryNamesAndValues.get(i2 + 1));
        }
        return Collections.unmodifiableList(arrayList2);
    }

    /*
     * WARNING - void declaration
     */
    public String queryParameterName(int index) {
        List<String> this_ = ((MBHttpUrl)((Object)this_)).queryNamesAndValues;
        if (this_ != null) {
            void var1_1;
            return (String)this_.get((int)(var1_1 * 2));
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - void declaration
     */
    public String queryParameterValue(int index) {
        List<String> this_ = ((MBHttpUrl)((Object)this_)).queryNamesAndValues;
        if (this_ != null) {
            void var1_1;
            return (String)this_.get((int)(var1_1 * 2 + true));
        }
        throw new IndexOutOfBoundsException();
    }

    public String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        MBHttpUrl mBHttpUrl = this;
        int n2 = mBHttpUrl.url.indexOf(35) + 1;
        return mBHttpUrl.url.substring(n2);
    }

    public String fragment() {
        return this.fragment;
    }

    public String redact() {
        return this.newBuilder("/...").username("").password("").build().toString();
    }

    /*
     * WARNING - void declaration
     */
    public MBHttpUrl resolve(String link) {
        void var1_1;
        return (this = ((MBHttpUrl)this).newBuilder((String)var1_1)) != null ? ((Builder)this).build() : null;
    }

    public Builder newBuilder() {
        Builder builder;
        Builder builder2 = builder;
        builder2();
        builder2.scheme = this.scheme;
        builder2.encodedUsername = this.encodedUsername();
        builder2.encodedPassword = this.encodedPassword();
        builder.host = this.host;
        int n2 = this.port != MBHttpUrl.defaultPort(this.scheme) ? this.port : -1;
        Builder builder3 = builder2;
        builder3.port = n2;
        builder3.encodedPathSegments.clear();
        builder3.encodedPathSegments.addAll(this.encodedPathSegments());
        builder2.encodedQuery(this.encodedQuery());
        builder2.encodedFragment = this.encodedFragment();
        return builder2;
    }

    /*
     * WARNING - void declaration
     */
    public Builder newBuilder(String link) {
        try {
            void var1_1;
            return new Builder().parse(this, (String)var1_1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        return other instanceof MBHttpUrl && ((MBHttpUrl)var1_1).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    public String topPrivateDomain() {
        return Util.verifyAsIpAddress((String)this.host) ? null : PublicSuffixDatabase.get().getEffectiveTldPlusOne(this.host);
    }

    public static final class Builder {
        static final String INVALID_HOST = "Invalid URL host";
        String scheme;
        String encodedUsername = "";
        String encodedPassword = "";
        String host;
        int port = -1;
        final List<String> encodedPathSegments;
        List<String> encodedQueryNamesAndValues;
        String encodedFragment;

        public Builder() {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList2();
            this.encodedPathSegments = arrayList2;
            arrayList.add("");
        }

        /*
         * WARNING - void declaration
         */
        private Builder addPathSegments(String pathSegments, boolean alreadyEncoded) {
            void var1_1;
            int n2;
            int n3 = 0;
            do {
                void var2_2;
                boolean bl = (n2 = Util.delimiterOffset((String)var1_1, (int)n3, (int)var1_1.length(), (String)"/\\")) < var1_1.length();
                this.push((String)var1_1, n3, n2, bl, (boolean)var2_2);
            } while ((n3 = n2 + 1) <= var1_1.length());
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private void removeAllCanonicalQueryParameters(String canonicalName) {
            for (int i2 = this.encodedQueryNamesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
                void var1_1;
                if (!var1_1.equals(this.encodedQueryNamesAndValues.get(i2))) continue;
                Builder builder = this;
                builder.encodedQueryNamesAndValues.remove(i2 + 1);
                builder.encodedQueryNamesAndValues.remove(i2);
                if (!builder.encodedQueryNamesAndValues.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void resolvePath(String input, int pos, int limit) {
            void var3_3;
            if (pos != var3_3) {
                int n2;
                void var1_1;
                int n3 = var1_1.charAt(n2);
                if (n3 != 47 && n3 != 92) {
                    List<String> list = this.encodedPathSegments;
                    list.set(list.size() - 1, "");
                } else {
                    Builder builder = this;
                    builder.encodedPathSegments.clear();
                    builder.encodedPathSegments.add("");
                    ++n2;
                }
                while (n2 < var3_3) {
                    n3 = Util.delimiterOffset((String)var1_1, (int)n2, (int)var3_3, (String)"/\\");
                    boolean bl = n3 < var3_3;
                    this.push((String)var1_1, n2, n3, bl, true);
                    if (bl) {
                        n2 = n3 + 1;
                        continue;
                    }
                    n2 = n3;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void push(String input, int pos, int limit, boolean addTrailingSlash, boolean alreadyEncoded) {
            void var5_5;
            void var3_3;
            void var2_2;
            String string;
            if (!this.isDot(string = MBHttpUrl.canonicalize(string, (int)var2_2, (int)var3_3, " \"<>^`{}|/\\?#", (boolean)var5_5, false, false, true, null))) {
                if (this.isDotDot(string)) {
                    this.pop();
                } else {
                    void var4_4;
                    List<String> list = this.encodedPathSegments;
                    if (list.get(list.size() - 1).isEmpty()) {
                        List<String> list2 = this.encodedPathSegments;
                        list2.set(list2.size() - 1, string);
                    } else {
                        this.encodedPathSegments.add(string);
                    }
                    if (var4_4 != false) {
                        this.encodedPathSegments.add("");
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean isDot(String input) {
            void var1_1;
            return input.equals(".") || var1_1.equalsIgnoreCase("%2e");
        }

        /*
         * WARNING - void declaration
         */
        private boolean isDotDot(String input) {
            void var1_1;
            return input.equals("..") || var1_1.equalsIgnoreCase("%2e.") || var1_1.equalsIgnoreCase(".%2e") || var1_1.equalsIgnoreCase("%2e%2e");
        }

        private void pop() {
            List<String> list = this.encodedPathSegments;
            if (list.remove(list.size() - 1).isEmpty() && !this.encodedPathSegments.isEmpty()) {
                List<String> list2 = this.encodedPathSegments;
                list2.set(list2.size() - 1, "");
            } else {
                this.encodedPathSegments.add("");
            }
        }

        /*
         * WARNING - void declaration
         */
        private static int schemeDelimiterOffset(String input, int pos, int limit) {
            String string;
            void var1_1;
            if (limit - var1_1 < 2) {
                return -1;
            }
            char c2 = string.charAt((int)var1_1);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                void var2_2;
                while (++var1_1 < var2_2) {
                    c2 = string.charAt((int)var1_1);
                    if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '+' || c2 == '-' || c2 == '.') continue;
                    if (c2 == ':') {
                        return (int)var1_1;
                    }
                    return -1;
                }
                return -1;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        private static int slashCount(String input, int pos, int limit) {
            String string;
            char c2;
            void var2_2;
            void var1_1;
            int n2 = 0;
            while (var1_1 < var2_2 && ((c2 = string.charAt((int)var1_1)) == '\\' || c2 == '/')) {
                ++n2;
                ++var1_1;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        private static int portColonOffset(String input, int pos, int limit) {
            void var2_2;
            while (pos < var2_2) {
                void var1_1;
                String string;
                char c2 = string.charAt((int)var1_1);
                if (c2 != ':') {
                    if (c2 == '[') {
                        while (++var1_1 < var2_2 && string.charAt((int)var1_1) != ']') {
                        }
                    }
                    ++var1_1;
                    continue;
                }
                return (int)var1_1;
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private static String canonicalizeHost(String input, int pos, int limit) {
            void var2_2;
            void var1_1;
            return Util.canonicalizeHost((String)MBHttpUrl.percentDecode(input, (int)var1_1, (int)var2_2, false));
        }

        /*
         * WARNING - void declaration
         */
        private static int parsePort(String input, int pos, int limit) {
            void var2_3;
            Charset charset;
            boolean bl;
            boolean bl2;
            int n2;
            String string;
            void v1;
            boolean bl3;
            String string2;
            try {
                string2 = input;
                v1 = bl3;
                string = "";
                n2 = 0;
                bl3 = false;
                bl2 = false;
                bl = true;
                charset = null;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            n2 = Integer.parseInt(MBHttpUrl.canonicalize(string2, (int)v1, (int)var2_3, string, n2 != 0, bl3, bl2, bl, charset));
            if (n2 <= 0 || n2 > 65535) {
                n2 = -1;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public Builder scheme(String scheme) {
            block2: {
                void var1_1;
                block5: {
                    block4: {
                        block3: {
                            if (scheme == null) break block2;
                            if (!var1_1.equalsIgnoreCase("http")) break block3;
                            this.scheme = "http";
                            break block4;
                        }
                        if (!var1_1.equalsIgnoreCase("https")) break block5;
                        this.scheme = "https";
                    }
                    return this;
                }
                throw new IllegalArgumentException("unexpected scheme: " + (String)var1_1);
            }
            throw new NullPointerException("scheme == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder username(String username) {
            if (username != null) {
                void var1_1;
                this.encodedUsername = MBHttpUrl.canonicalize((String)var1_1, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
                return this;
            }
            throw new NullPointerException("username == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder encodedUsername(String encodedUsername) {
            if (encodedUsername != null) {
                void var1_1;
                this.encodedUsername = MBHttpUrl.canonicalize((String)var1_1, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
                return this;
            }
            throw new NullPointerException("encodedUsername == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder password(String password) {
            if (password != null) {
                void var1_1;
                this.encodedPassword = MBHttpUrl.canonicalize((String)var1_1, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
                return this;
            }
            throw new NullPointerException("password == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder encodedPassword(String encodedPassword) {
            if (encodedPassword != null) {
                void var1_1;
                this.encodedPassword = MBHttpUrl.canonicalize((String)var1_1, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
                return this;
            }
            throw new NullPointerException("encodedPassword == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder host(String host) {
            if (host != null) {
                void var1_1;
                void v02 = var1_1;
                String string = Builder.canonicalizeHost((String)v02, 0, v02.length());
                if (string != null) {
                    this.host = string;
                    return this;
                }
                throw new IllegalArgumentException("unexpected host: " + (String)var1_1);
            }
            throw new NullPointerException("host == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder port(int port) {
            void var1_1;
            if (port > 0 && var1_1 <= 65535) {
                this.port = var1_1;
                return this;
            }
            throw new IllegalArgumentException("unexpected port: " + (int)var1_1);
        }

        public int effectivePort() {
            int n2 = this.port;
            if (n2 == -1) {
                n2 = MBHttpUrl.defaultPort(this.scheme);
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public Builder addPathSegment(String pathSegment) {
            if (pathSegment != null) {
                void var1_2;
                Builder builder = this;
                int n2 = var1_2.length();
                builder.push((String)var1_2, 0, n2, false, false);
                return builder;
            }
            throw new NullPointerException("pathSegment == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder addPathSegments(String pathSegments) {
            if (pathSegments != null) {
                void var1_1;
                return this.addPathSegments((String)var1_1, false);
            }
            throw new NullPointerException("pathSegments == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder addEncodedPathSegment(String encodedPathSegment) {
            if (encodedPathSegment != null) {
                void var1_2;
                Builder builder = this;
                int n2 = var1_2.length();
                builder.push((String)var1_2, 0, n2, false, true);
                return builder;
            }
            throw new NullPointerException("encodedPathSegment == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder addEncodedPathSegments(String encodedPathSegments) {
            if (encodedPathSegments != null) {
                void var1_1;
                return this.addPathSegments((String)var1_1, true);
            }
            throw new NullPointerException("encodedPathSegments == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPathSegment(int index, String pathSegment) {
            if (pathSegment != null) {
                void var2_2;
                void v02 = var2_2;
                String string = MBHttpUrl.canonicalize((String)v02, 0, v02.length(), " \"<>^`{}|/\\?#", false, false, false, true, null);
                if (!this.isDot(string) && !this.isDotDot(string)) {
                    void var1_1;
                    Builder builder = this;
                    builder.encodedPathSegments.set((int)var1_1, string);
                    return builder;
                }
                throw new IllegalArgumentException("unexpected path segment: " + (String)var2_2);
            }
            throw new NullPointerException("pathSegment == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder setEncodedPathSegment(int index, String encodedPathSegment) {
            if (encodedPathSegment != null) {
                void var1_1;
                void var2_2;
                void v02 = var2_2;
                String string = MBHttpUrl.canonicalize((String)v02, 0, v02.length(), " \"<>^`{}|/\\?#", true, false, false, true, null);
                this.encodedPathSegments.set((int)var1_1, string);
                if (!this.isDot(string) && !this.isDotDot(string)) {
                    return this;
                }
                throw new IllegalArgumentException("unexpected path segment: " + (String)var2_2);
            }
            throw new NullPointerException("encodedPathSegment == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder removePathSegment(int index) {
            void var1_1;
            Builder builder = this;
            builder.encodedPathSegments.remove((int)var1_1);
            if (builder.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add("");
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder encodedPath(String encodedPath) {
            if (encodedPath != null) {
                void var1_2;
                if (var1_2.startsWith("/")) {
                    Builder builder = this;
                    int n2 = var1_2.length();
                    builder.resolvePath((String)var1_2, 0, n2);
                    return builder;
                }
                throw new IllegalArgumentException("unexpected encodedPath: " + (String)var1_2);
            }
            throw new NullPointerException("encodedPath == null");
        }

        public Builder query(String query) {
            List<String> list;
            list = query != null ? MBHttpUrl.queryStringToNamesAndValues(MBHttpUrl.canonicalize((String)((Object)list), " \"'<>#", false, false, true, true)) : null;
            this.encodedQueryNamesAndValues = list;
            return this;
        }

        public Builder encodedQuery(String encodedQuery) {
            List<String> list;
            list = encodedQuery != null ? MBHttpUrl.queryStringToNamesAndValues(MBHttpUrl.canonicalize((String)((Object)list), " \"'<>#", true, false, true, true)) : null;
            this.encodedQueryNamesAndValues = list;
            return this;
        }

        public Builder addQueryParameter(String name, String value) {
            if (name != null) {
                String string;
                List<String> list;
                if (this.encodedQueryNamesAndValues == null) {
                    ArrayList<String> arrayList;
                    ArrayList<String> arrayList2 = arrayList;
                    arrayList = new ArrayList<String>();
                    this.encodedQueryNamesAndValues = arrayList2;
                }
                Builder builder = this;
                builder.encodedQueryNamesAndValues.add(MBHttpUrl.canonicalize((String)((Object)list), " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, true));
                list = builder.encodedQueryNamesAndValues;
                string = string != null ? MBHttpUrl.canonicalize(string, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, true) : null;
                list.add(string);
                return this;
            }
            throw new NullPointerException("name == null");
        }

        public Builder addEncodedQueryParameter(String encodedName, String encodedValue) {
            if (encodedName != null) {
                String string;
                List<String> list;
                if (this.encodedQueryNamesAndValues == null) {
                    ArrayList<String> arrayList;
                    ArrayList<String> arrayList2 = arrayList;
                    arrayList = new ArrayList<String>();
                    this.encodedQueryNamesAndValues = arrayList2;
                }
                Builder builder = this;
                builder.encodedQueryNamesAndValues.add(MBHttpUrl.canonicalize((String)((Object)list), " \"'<>#&=", true, false, true, true));
                list = builder.encodedQueryNamesAndValues;
                string = string != null ? MBHttpUrl.canonicalize(string, " \"'<>#&=", true, false, true, true) : null;
                list.add(string);
                return this;
            }
            throw new NullPointerException("encodedName == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder setQueryParameter(String name, String value) {
            void var2_2;
            void var1_1;
            Builder builder = this;
            builder.removeAllQueryParameters((String)var1_1);
            builder.addQueryParameter((String)var1_1, (String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setEncodedQueryParameter(String encodedName, String encodedValue) {
            void var2_2;
            void var1_1;
            Builder builder = this;
            builder.removeAllEncodedQueryParameters((String)var1_1);
            builder.addEncodedQueryParameter((String)var1_1, (String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public Builder removeAllQueryParameters(String name) {
            if (name != null) {
                void var1_1;
                if (this.encodedQueryNamesAndValues == null) {
                    return this;
                }
                Builder builder = this;
                builder.removeAllCanonicalQueryParameters(MBHttpUrl.canonicalize((String)var1_1, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, true));
                return builder;
            }
            throw new NullPointerException("name == null");
        }

        /*
         * WARNING - void declaration
         */
        public Builder removeAllEncodedQueryParameters(String encodedName) {
            if (encodedName != null) {
                void var1_1;
                if (this.encodedQueryNamesAndValues == null) {
                    return this;
                }
                Builder builder = this;
                builder.removeAllCanonicalQueryParameters(MBHttpUrl.canonicalize((String)var1_1, " \"'<>#&=", true, false, true, true));
                return builder;
            }
            throw new NullPointerException("encodedName == null");
        }

        public Builder fragment(String fragment) {
            String string;
            string = fragment != null ? MBHttpUrl.canonicalize(string, "", false, false, false, false) : null;
            this.encodedFragment = string;
            return this;
        }

        public Builder encodedFragment(String encodedFragment) {
            String string;
            string = encodedFragment != null ? MBHttpUrl.canonicalize(string, "", true, false, false, false) : null;
            this.encodedFragment = string;
            return this;
        }

        public Builder reencodeForUri() {
            String string;
            String string2;
            int n2 = this.encodedPathSegments.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Builder builder = this;
                string2 = builder.encodedPathSegments.get(i2);
                builder.encodedPathSegments.set(i2, MBHttpUrl.canonicalize(string2, "[]", true, true, false, true));
            }
            List<String> list = this.encodedQueryNamesAndValues;
            if (list != null) {
                n2 = list.size();
                for (int i3 = 0; i3 < n2; ++i3) {
                    string2 = this.encodedQueryNamesAndValues.get(i3);
                    if (string2 == null) continue;
                    this.encodedQueryNamesAndValues.set(i3, MBHttpUrl.canonicalize(string2, "\\^`{|}", true, true, true, true));
                }
            }
            if ((string = this.encodedFragment) != null) {
                this.encodedFragment = MBHttpUrl.canonicalize(string, " \"#<>\\^`{|}", true, true, false, false);
            }
            return this;
        }

        public MBHttpUrl build() {
            if (this.scheme != null) {
                if (this.host != null) {
                    return new MBHttpUrl(this);
                }
                throw new IllegalStateException("host == null");
            }
            throw new IllegalStateException("scheme == null");
        }

        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            String string = this.scheme;
            if (string != null) {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append(string);
                stringBuilder3.append("://");
            } else {
                stringBuilder2.append("//");
            }
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                stringBuilder2.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    stringBuilder2.append(':');
                    stringBuilder2.append(this.encodedPassword);
                }
                stringBuilder2.append('@');
            }
            if ((string = this.host) != null) {
                if (string.indexOf(58) != -1) {
                    StringBuilder stringBuilder4 = stringBuilder2;
                    stringBuilder2.append('[');
                    stringBuilder4.append(this.host);
                    stringBuilder4.append(']');
                } else {
                    stringBuilder2.append(this.host);
                }
            }
            if (this.port != -1 || this.scheme != null) {
                Builder builder = this;
                int n2 = builder.effectivePort();
                String string2 = builder.scheme;
                if (string2 == null || n2 != MBHttpUrl.defaultPort(string2)) {
                    StringBuilder stringBuilder5 = stringBuilder2;
                    stringBuilder5.append(':');
                    stringBuilder5.append(n2);
                }
            }
            MBHttpUrl.pathSegmentsToString(stringBuilder2, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                stringBuilder2.append('?');
                MBHttpUrl.namesAndValuesToQueryString(stringBuilder2, this.encodedQueryNamesAndValues);
            }
            if (this.encodedFragment != null) {
                stringBuilder2.append('#');
                stringBuilder2.append(this.encodedFragment);
            }
            return stringBuilder2.toString();
        }

        /*
         * WARNING - void declaration
         */
        public Builder parse(MBHttpUrl base, String input) {
            block19: {
                int n2;
                int n3;
                void var2_5;
                block22: {
                    int n4;
                    int n5;
                    block21: {
                        int n6;
                        int n7;
                        block20: {
                            void var1_1;
                            block17: {
                                block15: {
                                    block18: {
                                        block16: {
                                            n5 = input.length();
                                            n5 = Util.skipLeadingAsciiWhitespace((String)var2_5, (int)0, (int)n5);
                                            n4 = var2_5.length();
                                            n3 = Builder.schemeDelimiterOffset((String)var2_5, n5, n4 = Util.skipTrailingAsciiWhitespace((String)var2_5, (int)n5, (int)n4));
                                            if (n3 == -1) break block15;
                                            if (!var2_5.regionMatches(true, n5, "https:", 0, 6)) break block16;
                                            this.scheme = "https";
                                            n5 += 6;
                                            break block17;
                                        }
                                        if (!var2_5.regionMatches(true, n5, "http:", 0, 5)) break block18;
                                        this.scheme = "http";
                                        n5 += 5;
                                        break block17;
                                    }
                                    throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but was '" + var2_5.substring(0, n3) + "'");
                                }
                                if (var1_1 == null) break block19;
                                this.scheme = var1_1.scheme;
                            }
                            n3 = 0;
                            n7 = 0;
                            n6 = Builder.slashCount((String)var2_5, n5, n4);
                            if (n6 >= 2 || var1_1 == null || !var1_1.scheme.equals(this.scheme)) break block20;
                            void v02 = var1_1;
                            this.encodedUsername = v02.encodedUsername();
                            this.encodedPassword = v02.encodedPassword();
                            this.host = v02.host;
                            this.port = v02.port;
                            this.encodedPathSegments.clear();
                            this.encodedPathSegments.addAll(var1_1.encodedPathSegments());
                            if (n5 == n4 || var2_5.charAt(n5) == '#') {
                                this.encodedQuery(var1_1.encodedQuery());
                            }
                            break block21;
                        }
                        n2 = n5 + n6;
                        while ((n6 = (n5 = Util.delimiterOffset((String)var2_5, (int)n2, (int)n4, (String)"@/\\?#")) != n4 ? (int)var2_5.charAt(n5) : -1) != -1 && n6 != 35 && n6 != 47 && n6 != 92 && n6 != 63) {
                            String string;
                            if (n6 != 64) continue;
                            if (n7 == 0) {
                                int n8 = n3;
                                n3 = Util.delimiterOffset((String)var2_5, (int)n2, (int)n5, (char)':');
                                string = MBHttpUrl.canonicalize((String)var2_5, n2, n3, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                if (n8 != 0) {
                                    string = this.encodedUsername + "%40" + string;
                                }
                                this.encodedUsername = string;
                                if (n3 != n5) {
                                    n7 = 1;
                                    this.encodedPassword = MBHttpUrl.canonicalize((String)var2_5, n3 + 1, n5, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                }
                                n3 = 1;
                            } else {
                                String string2 = this.encodedPassword;
                                string = MBHttpUrl.canonicalize((String)var2_5, n2, n5, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                Object[] objectArray = new Object[2];
                                Object[] objectArray2 = objectArray;
                                objectArray[0] = string2;
                                objectArray[1] = string;
                                this.encodedPassword = String.format("%s%%40%s", objectArray2);
                            }
                            n2 = n5 + 1;
                        }
                        n3 = Builder.portColonOffset((String)var2_5, n2, n5);
                        n7 = n3 + 1;
                        if (n7 < n5) {
                            this.host = Builder.canonicalizeHost((String)var2_5, n2, n3);
                            this.port = Builder.parsePort((String)var2_5, n7, n5);
                            if (this.port == -1) {
                                throw new IllegalArgumentException("Invalid URL port: \"" + var2_5.substring(n7, n5) + '\"');
                            }
                        } else {
                            this.host = Builder.canonicalizeHost((String)var2_5, n2, n3);
                            this.port = MBHttpUrl.defaultPort(this.scheme);
                        }
                        if (this.host == null) break block22;
                    }
                    int n9 = Util.delimiterOffset((String)var2_5, (int)n5, (int)n4, (String)"?#");
                    this.resolvePath((String)var2_5, n5, n9);
                    if (n9 < n4 && var2_5.charAt(n9) == '?') {
                        n5 = Util.delimiterOffset((String)var2_5, (int)n9, (int)n4, (char)'#');
                        this.encodedQueryNamesAndValues = MBHttpUrl.queryStringToNamesAndValues(MBHttpUrl.canonicalize((String)var2_5, n9 + 1, n5, " \"'<>#", true, false, true, true, null));
                        n9 = n5;
                    }
                    if (n9 < n4 && var2_5.charAt(n9) == '#') {
                        this.encodedFragment = MBHttpUrl.canonicalize((String)var2_5, n9 + 1, n4, "", true, false, false, false, null);
                    }
                    return this;
                }
                throw new IllegalArgumentException("Invalid URL host: \"" + var2_5.substring(n2, n3) + '\"');
            }
            throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no colon was found");
        }
    }
}

