/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.data;

import ae.trdqad.data.AdvertisingIdKt;
import ae.trdqad.data.HmsAdvertisingIdKt;
import ae.trdqad.data.LocationManagerKt;
import ae.trdqad.data.PackageCollectorKt;
import ae.trdqad.data.UtilsKt;
import android.content.Context;
import android.graphics.Point;
import android.location.Location;
import android.os.Build;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lae/trdqad/data/DataCollector;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "getDataAsTask", "Lorg/json/JSONObject;", "data_release"})
public final class DataCollector {
    @NotNull
    private final Context context;

    public DataCollector(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final JSONObject getDataAsTask() {
        JSONObject jSONObject;
        String advertisingId = AdvertisingIdKt.getAdvertisingId(this.context);
        String hmsAdvertisingId = HmsAdvertisingIdKt.getHuaweiAdvertisingId(this.context);
        Location location = LocationManagerKt.getLocation(this.context);
        if (location == null) {
            Log.d((String)"DataCollector", (String)"location not available");
        }
        JSONArray packages = PackageCollectorKt.getPackageLists(this.context);
        JSONObject $this$getDataAsTask_u24lambda_u2d0 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$getDataAsTask_u24lambda_u2d0.put("api_level", Build.VERSION.SDK_INT);
        $this$getDataAsTask_u24lambda_u2d0.put("os", (Object)"Android");
        $this$getDataAsTask_u24lambda_u2d0.put("brand", (Object)Build.BRAND);
        $this$getDataAsTask_u24lambda_u2d0.put("model", (Object)Build.MODEL);
        $this$getDataAsTask_u24lambda_u2d0.put("carrier", (Object)UtilsKt.getCarrier(this.context));
        $this$getDataAsTask_u24lambda_u2d0.put("http_agent", (Object)UtilsKt.obtainHttpAgentString(this.context));
        $this$getDataAsTask_u24lambda_u2d0.put("collector_version", (Object)"1.0.0");
        Point screenSize = UtilsKt.getScreenSize(this.context);
        $this$getDataAsTask_u24lambda_u2d0.put("screen_width", screenSize.x);
        $this$getDataAsTask_u24lambda_u2d0.put("screen_height", screenSize.y);
        $this$getDataAsTask_u24lambda_u2d0.put("screen_dpi", UtilsKt.getScreenDpi(this.context));
        Location location2 = location;
        $this$getDataAsTask_u24lambda_u2d0.put("latitude", (Object)(location2 != null ? Double.valueOf(location2.getLatitude()) : null));
        Location location3 = location;
        $this$getDataAsTask_u24lambda_u2d0.put("longitude", (Object)(location3 != null ? Double.valueOf(location3.getLongitude()) : null));
        String string = advertisingId;
        if (string == null) {
            string = hmsAdvertisingId;
        }
        $this$getDataAsTask_u24lambda_u2d0.put("advertising_id", (Object)string);
        JSONObject device = jSONObject;
        JSONObject $this$getDataAsTask_u24lambda_u2d1 = jSONObject = new JSONObject();
        boolean bl2 = false;
        $this$getDataAsTask_u24lambda_u2d1.put("gmsAdvertisingId", (Object)advertisingId);
        $this$getDataAsTask_u24lambda_u2d1.put("hmsAdvertisingId", (Object)advertisingId);
        Location location4 = location;
        $this$getDataAsTask_u24lambda_u2d1.put("location_latitude", (Object)(location4 != null ? Double.valueOf(location4.getLatitude()) : null));
        Location location5 = location;
        $this$getDataAsTask_u24lambda_u2d1.put("location_longitude", (Object)(location5 != null ? Double.valueOf(location5.getLongitude()) : null));
        $this$getDataAsTask_u24lambda_u2d1.put("installedPackages", (Object)packages);
        $this$getDataAsTask_u24lambda_u2d1.put("collector_version", (Object)"1.0.0");
        $this$getDataAsTask_u24lambda_u2d1.put("device", (Object)device);
        return jSONObject;
    }
}

