/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.data;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"AFD_MAX_COUNT_OVERLAPPED_VIEWS", "", "defaultHttpAgentString", "", "httpAgentString", "uiHandler", "Landroid/os/Handler;", "convertDpToPixel", "", "dp", "context", "Landroid/content/Context;", "getApplicationInfo", "Landroid/content/pm/ApplicationInfo;", "getCarrier", "getInstallationSource", "getInstalledMarkets", "Lorg/json/JSONArray;", "getScreenDpi", "getScreenOrientation", "getScreenSize", "Landroid/graphics/Point;", "obtainDefaultHttpAgentString", "obtainHttpAgentString", "onUiThread", "", "runnable", "Ljava/lang/Runnable;", "data_release"})
public final class UtilsKt {
    @Nullable
    private static String defaultHttpAgentString = "";
    @Nullable
    private static String httpAgentString;
    private static final int AFD_MAX_COUNT_OVERLAPPED_VIEWS = 3;
    @NotNull
    private static final Handler uiHandler;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getCarrier(@NotNull Context context) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tel = (TelephonyManager)object;
        boolean bl = false;
        String name = tel.getNetworkOperatorName();
        return TextUtils.isEmpty((CharSequence)name) ? null : var3_3;
    }

    @Nullable
    public static final String obtainHttpAgentString(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CountDownLatch latch = new CountDownLatch(1);
        if (httpAgentString != null) {
            return httpAgentString;
        }
        UtilsKt.onUiThread(() -> UtilsKt.obtainHttpAgentString$lambda-1(context, latch));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return TextUtils.isEmpty((CharSequence)httpAgentString) ? UtilsKt.obtainDefaultHttpAgentString() : httpAgentString;
    }

    private static final String obtainDefaultHttpAgentString() {
        if (TextUtils.isEmpty((CharSequence)defaultHttpAgentString)) {
            try {
                defaultHttpAgentString = System.getProperty("http.agent", "");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultHttpAgentString;
    }

    @NotNull
    public static final Point getScreenSize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager window = (WindowManager)object;
        Point size = new Point();
        Display display = window.getDefaultDisplay();
        display.getSize(size);
        return size;
    }

    public static final int getScreenDpi(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager window = (WindowManager)object;
        Display display = window.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return displayMetrics.densityDpi;
    }

    @Nullable
    public static final String getInstallationSource(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        if (Build.VERSION.SDK_INT >= 30) {
            try {
                return packageManager.getInstallSourceInfo(packageName).getInstallingPackageName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return packageManager.getInstallerPackageName(packageName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public static final JSONArray getInstalledMarkets(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = Uri.parse((String)"market://details?id=com.android.chrome");
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        JSONArray installedMarkets = new JSONArray();
        try {
            for (ResolveInfo marketActivity : context.getPackageManager().queryIntentActivities(intent, 0)) {
                String packageName = marketActivity.activityInfo.packageName;
                if (TextUtils.isEmpty((CharSequence)packageName)) continue;
                installedMarkets.put((Object)packageName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return installedMarkets;
    }

    public static final void onUiThread(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            uiHandler.post(runnable);
        }
    }

    public static final float convertDpToPixel(float dp, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return dp < 0.0f ? dp : dp * ((float)context.getResources().getDisplayMetrics().densityDpi / (float)160);
    }

    public static final int getScreenOrientation(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        int rotation = windowManager.getDefaultDisplay().getRotation();
        int orientation = context.getResources().getConfiguration().orientation;
        block0 : switch (orientation) {
            case 1: {
                switch (rotation) {
                    case 2: 
                    case 3: {
                        n = 9;
                        break block0;
                    }
                    case 0: 
                    case 1: {
                        n = 1;
                        break block0;
                    }
                }
                n = 1;
                break;
            }
            case 2: {
                switch (rotation) {
                    case 2: 
                    case 3: {
                        n = 8;
                        break block0;
                    }
                    case 0: 
                    case 1: {
                        n = 0;
                        break block0;
                    }
                }
                n = 0;
                break;
            }
            default: {
                n = 9;
            }
        }
        return n;
    }

    private static final ApplicationInfo getApplicationInfo(Context context) {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void obtainHttpAgentString$lambda-1(Context $context, CountDownLatch $latch) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        try {
            httpAgentString = Build.VERSION.SDK_INT < 17 ? new WebView($context).getSettings().getUserAgentString() : WebSettings.getDefaultUserAgent((Context)$context);
        }
        catch (Throwable throwable) {
        }
        finally {
            $latch.countDown();
        }
    }

    static {
        uiHandler = new Handler(Looper.getMainLooper());
    }
}

