/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.data.common.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\n"}, d2={"saveLastKnownLocation", "", "context", "Landroid/content/Context;", "location", "Landroid/location/Location;", "saveLastSendLocation", "shouldSendLocationToServer", "", "tryLoadLocationFromDisk", "data_release"})
public final class UtilsKt {
    public static final boolean shouldSendLocationToServer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences prefs = context.getSharedPreferences("ae.trdqad.sdk", 0);
        long lastRequest = prefs.getLong("last_request_time", 0L);
        return TimeUnit.HOURS.toMillis(24L) < System.currentTimeMillis() - lastRequest;
    }

    public static final void saveLastSendLocation(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences prefs = context.getSharedPreferences("ae.trdqad.sdk", 0);
        prefs.edit().putLong("last_request_time", System.currentTimeMillis()).apply();
    }

    public static final void saveLastKnownLocation(@NotNull Context context, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        SharedPreferences prefs = context.getSharedPreferences("ae.trdqad.sdk", 0);
        prefs.edit().putLong("date", System.currentTimeMillis()).putString("lat", String.valueOf(location.getLatitude())).putString("lng", String.valueOf(location.getLongitude())).putString("acc", String.valueOf(location.getAccuracy())).putString("alt", String.valueOf(location.getAltitude())).apply();
    }

    @Nullable
    public static final Location tryLoadLocationFromDisk(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences prefs = context.getSharedPreferences("ae.trdqad.sdk", 0);
        long date = prefs.getLong("date", 0L);
        if (date == 0L || date - System.currentTimeMillis() > TimeUnit.DAYS.toMillis(1L)) {
            return null;
        }
        Location location = new Location("gps");
        String string = prefs.getString("lat", "0");
        Intrinsics.checkNotNull((Object)string);
        location.setLatitude(Double.parseDouble(string));
        String string2 = prefs.getString("lng", "0");
        Intrinsics.checkNotNull((Object)string2);
        location.setLongitude(Double.parseDouble(string2));
        String string3 = prefs.getString("acc", "0");
        Intrinsics.checkNotNull((Object)string3);
        location.setAccuracy(Float.parseFloat(string3));
        String string4 = prefs.getString("alt", "0");
        Intrinsics.checkNotNull((Object)string4);
        location.setAltitude(Double.parseDouble(string4));
        return location;
    }
}

