/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.data.location;

import ae.trdqad.base.AdvertisingId;
import ae.trdqad.base.remote.ApiRequest;
import ae.trdqad.data.DataCollector;
import ae.trdqad.data.common.utils.UtilsKt;
import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0017\u00a8\u0006\t"}, d2={"Lae/trdqad/data/location/LocationReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "data_release"})
public final class LocationReceiver
extends BroadcastReceiver {
    @SuppressLint(value={"MissingPermission"})
    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        boolean locationEnabled;
        if (context == null || intent == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return;
        }
        AdvertisingId.Companion.init(context);
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager locationManager = (LocationManager)object;
        boolean bl = locationEnabled = locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network");
        if (locationEnabled) {
            Location location = null;
            location = locationManager.getLastKnownLocation("gps");
            if (location == null) {
                location = locationManager.getLastKnownLocation("network");
            }
            if (location == null) {
                location = UtilsKt.tryLoadLocationFromDisk(context);
            }
            if (location != null) {
                UtilsKt.saveLastKnownLocation(context, location);
                if (UtilsKt.shouldSendLocationToServer(context)) {
                    JSONObject jSONObject;
                    String advertisingId = new DataCollector(context).getDataAsTask().getJSONObject("device").getString("advertising_id");
                    JSONObject $this$onReceive_u24lambda_u2d0 = jSONObject = new JSONObject();
                    boolean bl2 = false;
                    $this$onReceive_u24lambda_u2d0.put("advertising_id", (Object)advertisingId);
                    $this$onReceive_u24lambda_u2d0.put("lat", location.getLatitude());
                    $this$onReceive_u24lambda_u2d0.put("lng", location.getLongitude());
                    $this$onReceive_u24lambda_u2d0.put("acc", (Object)Float.valueOf(location.getAccuracy()));
                    $this$onReceive_u24lambda_u2d0.put("alt", location.getAltitude());
                    JSONObject body = jSONObject;
                    ApiRequest request = new ApiRequest("https://audience.trdqad.ae", body);
                    request.get();
                    UtilsKt.saveLastSendLocation(context);
                }
            }
        }
    }
}

