/*
 * Decompiled with CFR 0.152.
 */
package java9.lang;

import java.util.Collection;
import java.util.Iterator;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.Spliterators;
import java9.util.function.Consumer;
import java9.util.function.Predicate;

public final class Iterables {
    public static <T> void forEach(Iterable<? extends T> it, Consumer<? super T> action) {
        Objects.requireNonNull(it);
        Objects.requireNonNull(action);
        for (T t : it) {
            action.accept(t);
        }
    }

    public static <T> boolean removeIf(Iterable<? extends T> it, Predicate<? super T> filter) {
        Objects.requireNonNull(it);
        Objects.requireNonNull(filter);
        boolean removed = false;
        Iterator<T> each = it.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.next())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    public static <T> Spliterator<T> spliterator(Iterable<? extends T> it) {
        if (it instanceof Collection) {
            Collection c = (Collection)it;
            return Spliterators.spliterator(c);
        }
        return Spliterators.spliteratorUnknownSize(it.iterator(), 0);
    }

    private Iterables() {
    }
}

