/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.base.cookie;

import ae.trdqad.base.Logger;
import java.net.HttpCookie;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lae/trdqad/base/cookie/CookieSerializer;", "", "()V", "KEY_COMMENT", "", "KEY_COMMENT_URL", "KEY_DISCARD", "KEY_DOMAIN", "KEY_MAX_AGE", "KEY_NAME", "KEY_PATH", "KEY_PORTLIST", "KEY_SECURE", "KEY_VALUE", "KEY_VERSION", "deserializeCookie", "Ljava/net/HttpCookie;", "serializedCookie", "serializeCookie", "cookie", "base_release"})
public final class CookieSerializer {
    @NotNull
    public static final CookieSerializer INSTANCE = new CookieSerializer();
    @NotNull
    private static final String KEY_NAME = "name";
    @NotNull
    private static final String KEY_VALUE = "value";
    @NotNull
    private static final String KEY_COMMENT = "comment";
    @NotNull
    private static final String KEY_COMMENT_URL = "comment_url";
    @NotNull
    private static final String KEY_DOMAIN = "domain";
    @NotNull
    private static final String KEY_MAX_AGE = "max_age";
    @NotNull
    private static final String KEY_PATH = "path";
    @NotNull
    private static final String KEY_PORTLIST = "portlist";
    @NotNull
    private static final String KEY_VERSION = "version";
    @NotNull
    private static final String KEY_SECURE = "secure";
    @NotNull
    private static final String KEY_DISCARD = "discard";

    private CookieSerializer() {
    }

    @Nullable
    public final HttpCookie deserializeCookie(@Nullable String serializedCookie) {
        HttpCookie httpCookie;
        try {
            JSONObject json = new JSONObject(serializedCookie);
            String name = json.getString(KEY_NAME);
            String value = json.getString(KEY_VALUE);
            HttpCookie cookie = new HttpCookie(name, value);
            if (json.has(KEY_COMMENT)) {
                cookie.setComment(json.getString(KEY_COMMENT));
            }
            if (json.has(KEY_COMMENT_URL)) {
                cookie.setCommentURL(json.getString(KEY_COMMENT_URL));
            }
            if (json.has(KEY_DOMAIN)) {
                cookie.setDomain(json.getString(KEY_DOMAIN));
            }
            if (json.has(KEY_MAX_AGE)) {
                cookie.setMaxAge(json.getLong(KEY_MAX_AGE));
            }
            if (json.has(KEY_PATH)) {
                cookie.setPath(json.getString(KEY_PATH));
            }
            if (json.has(KEY_PORTLIST)) {
                cookie.setPortlist(json.getString(KEY_PORTLIST));
            }
            if (json.has(KEY_VERSION)) {
                cookie.setVersion(json.getInt(KEY_VERSION));
            }
            if (json.has(KEY_SECURE)) {
                cookie.setSecure(json.getBoolean(KEY_SECURE));
            }
            if (json.has(KEY_DISCARD)) {
                cookie.setDiscard(json.getBoolean(KEY_DISCARD));
            }
            httpCookie = cookie;
        }
        catch (JSONException e) {
            Logger.INSTANCE.d("Cookie deserialization error", e);
            httpCookie = null;
        }
        return httpCookie;
    }

    @Nullable
    public final String serializeCookie(@NotNull HttpCookie cookie) {
        String string;
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        try {
            JSONObject json = new JSONObject();
            json.put(KEY_NAME, (Object)cookie.getName());
            json.put(KEY_VALUE, (Object)cookie.getValue());
            json.put(KEY_COMMENT, (Object)cookie.getComment());
            json.put(KEY_COMMENT_URL, (Object)cookie.getCommentURL());
            json.put(KEY_DOMAIN, (Object)cookie.getDomain());
            json.put(KEY_MAX_AGE, cookie.getMaxAge());
            json.put(KEY_PATH, (Object)cookie.getPath());
            json.put(KEY_PORTLIST, (Object)cookie.getPortlist());
            json.put(KEY_VERSION, cookie.getVersion());
            json.put(KEY_SECURE, cookie.getSecure());
            json.put(KEY_DISCARD, cookie.getDiscard());
            string = json.toString();
        }
        catch (JSONException e) {
            Logger.INSTANCE.d("Cookie serialization error", e);
            string = null;
        }
        return string;
    }
}

