/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.base.cookie;

import ae.trdqad.base.cookie.PersistentCookieStore;
import android.content.Context;
import android.text.TextUtils;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lae/trdqad/base/cookie/CookieUtils;", "", "()V", "cookieStore", "Lae/trdqad/base/cookie/PersistentCookieStore;", "add", "", "connection", "Ljava/net/HttpURLConnection;", "initialize", "context", "Landroid/content/Context;", "store", "base_release"})
public final class CookieUtils {
    @NotNull
    public static final CookieUtils INSTANCE = new CookieUtils();
    @Nullable
    private static PersistentCookieStore cookieStore;

    private CookieUtils() {
    }

    public final void initialize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        cookieStore = new PersistentCookieStore(context);
    }

    public final void add(@NotNull HttpURLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        try {
            PersistentCookieStore persistentCookieStore = cookieStore;
            Intrinsics.checkNotNull((Object)persistentCookieStore);
            URI uRI = connection.getURL().toURI();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"connection.url.toURI()");
            List<HttpCookie> cookies = persistentCookieStore.get(uRI);
            connection.setRequestProperty("Cookie", TextUtils.join((CharSequence)";", (Iterable)cookies));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public final void store(@NotNull HttpURLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        try {
            URI uri = connection.getURL().toURI();
            Map<String, List<String>> responseHeaders = connection.getHeaderFields();
            Intrinsics.checkNotNullExpressionValue(responseHeaders, (String)"responseHeaders");
            for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
                String headerKey = entry.getKey();
                List<String> value = entry.getValue();
                if (headerKey == null || !StringsKt.equals((String)headerKey, (String)"Set-Cookie", (boolean)true)) continue;
                for (String headerValue : value) {
                    List<HttpCookie> cookies = HttpCookie.parse(headerValue);
                    for (HttpCookie cookie : cookies) {
                        PersistentCookieStore persistentCookieStore = cookieStore;
                        Intrinsics.checkNotNull((Object)persistentCookieStore);
                        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                        Intrinsics.checkNotNullExpressionValue((Object)cookie, (String)"cookie");
                        persistentCookieStore.add(uri, cookie);
                    }
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

