/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.base.cookie;

import ae.trdqad.base.Logger;
import ae.trdqad.base.cookie.CookieSerializer;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u000e\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0096\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001f\u001a\u00020\u000eH\u0002J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020\u000eH\u0002J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\tH\u0002J\u001e\u0010#\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0002J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\tH\u0002R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lae/trdqad/base/cookie/PersistentCookieStore;", "Ljava/net/CookieStore;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "allCookies", "Ljava/util/HashMap;", "Ljava/net/URI;", "", "Ljava/net/HttpCookie;", "Lkotlin/collections/HashMap;", "sharedPreferences", "Landroid/content/SharedPreferences;", "add", "", "cookieUri", "cookie", "checkDomainsMatch", "", "cookieHost", "", "requestHost", "checkPathsMatch", "cookiePath", "requestPath", "get", "", "uri", "getCookies", "getURIs", "getValidCookies", "loadAllFromPersistence", "remove", "removeAll", "removeAllFromPersistence", "removeFromPersistence", "cookieToRemove", "cookiesToRemove", "saveToPersistence", "Companion", "base_release"})
public final class PersistentCookieStore
implements CookieStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences sharedPreferences;
    @NotNull
    private final HashMap<URI, Set<HttpCookie>> allCookies;
    private static final String TAG = PersistentCookieStore.class.getSimpleName();
    @NotNull
    private static final String SP_COOKIE_STORE = "TradiqueCookieStore";
    @NotNull
    private static final String SP_KEY_DELIMITER = "|";
    @NotNull
    private static final String SP_KEY_DELIMITER_REGEX = "\\|";

    public PersistentCookieStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences(SP_COOKIE_STORE, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026RE, Context.MODE_PRIVATE)");
        this.sharedPreferences = sharedPreferences;
        this.allCookies = new HashMap();
        this.loadAllFromPersistence();
    }

    /*
     * WARNING - void declaration
     */
    private final void loadAllFromPersistence() {
        this.allCookies.clear();
        Map allPairs = this.sharedPreferences.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)allPairs, (String)"allPairs");
        for (Map.Entry entry : allPairs.entrySet()) {
            void $this$toTypedArray$iv;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Object object = key;
            Regex regex = new Regex(SP_KEY_DELIMITER_REGEX);
            int n = 2;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            try {
                String[] uriAndName;
                URI uri = new URI(uriAndName[0]);
                Object v = value;
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                String serializedCookie = (String)v;
                HttpCookie cookie = CookieSerializer.INSTANCE.deserializeCookie(serializedCookie);
                if (cookie == null) {
                    Logger.INSTANCE.i("Resetting cookie store");
                    this.removeAll();
                    return;
                }
                Set targetCookies = this.allCookies.get(uri);
                if (targetCookies == null) {
                    targetCookies = new HashSet();
                    ((Map)this.allCookies).put(uri, targetCookies);
                }
                targetCookies.add((HttpCookie)cookie);
            }
            catch (URISyntaxException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void add(@NotNull URI cookieUri, @NotNull HttpCookie cookie) {
        Intrinsics.checkNotNullParameter((Object)cookieUri, (String)"cookieUri");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        URI uri = cookieUri;
        uri = PersistentCookieStore.Companion.cookieUri(uri, cookie);
        Set targetCookies = this.allCookies.get(uri);
        if (targetCookies == null) {
            targetCookies = new HashSet();
            ((Map)this.allCookies).put(uri, targetCookies);
        }
        targetCookies.remove(cookie);
        targetCookies.add(cookie);
        this.saveToPersistence(uri, cookie);
    }

    private final void saveToPersistence(URI uri, HttpCookie cookie) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        String serializedCookie = CookieSerializer.INSTANCE.serializeCookie(cookie);
        if (serializedCookie != null) {
            editor.putString(uri.toString() + '|' + cookie.getName(), serializedCookie);
            editor.apply();
        }
    }

    @Override
    @NotNull
    public synchronized List<HttpCookie> get(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.getValidCookies(uri);
    }

    @Override
    @NotNull
    public synchronized List<HttpCookie> getCookies() {
        List allValidCookies = new ArrayList();
        for (URI storedUri : this.allCookies.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)storedUri, (String)"storedUri");
            allValidCookies.addAll((Collection)this.getValidCookies(storedUri));
        }
        return allValidCookies;
    }

    private final List<HttpCookie> getValidCookies(URI uri) {
        List targetCookies = new ArrayList();
        for (URI storedUri : this.allCookies.keySet()) {
            String string = storedUri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"storedUri.host");
            String string2 = uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.host");
            if (!this.checkDomainsMatch(string, string2)) continue;
            String string3 = storedUri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"storedUri.path");
            String string4 = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"uri.path");
            if (!this.checkPathsMatch(string3, string4)) continue;
            Set<HttpCookie> set = this.allCookies.get(storedUri);
            Intrinsics.checkNotNull(set);
            targetCookies.addAll((Collection)set);
        }
        if (!((Collection)targetCookies).isEmpty()) {
            List cookiesToRemoveFromPersistence = new ArrayList();
            Iterator it = targetCookies.iterator();
            while (it.hasNext()) {
                HttpCookie currentCookie = (HttpCookie)it.next();
                if (!currentCookie.hasExpired()) continue;
                cookiesToRemoveFromPersistence.add(currentCookie);
                it.remove();
            }
            if (!((Collection)cookiesToRemoveFromPersistence).isEmpty()) {
                this.removeFromPersistence(uri, cookiesToRemoveFromPersistence);
            }
        }
        return targetCookies;
    }

    private final boolean checkDomainsMatch(String cookieHost, String requestHost) {
        return Intrinsics.areEqual((Object)requestHost, (Object)cookieHost) || StringsKt.endsWith$default((String)requestHost, (String)('.' + cookieHost), (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkPathsMatch(String cookiePath, String requestPath) {
        if (Intrinsics.areEqual((Object)requestPath, (Object)cookiePath)) return true;
        if (StringsKt.startsWith$default((String)requestPath, (String)cookiePath, (boolean)false, (int)2, null)) {
            if (cookiePath.charAt(cookiePath.length() - 1) == '/') return true;
        }
        if (!StringsKt.startsWith$default((String)requestPath, (String)cookiePath, (boolean)false, (int)2, null)) return false;
        String string = requestPath.substring(cookiePath.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        if (string.charAt(0) != '/') return false;
        return true;
    }

    private final void removeFromPersistence(URI uri, List<HttpCookie> cookiesToRemove) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        for (HttpCookie cookieToRemove : cookiesToRemove) {
            editor.remove(uri.toString() + '|' + cookieToRemove.getName());
        }
        editor.apply();
    }

    @Override
    @NotNull
    public synchronized List<URI> getURIs() {
        return new ArrayList(this.allCookies.keySet());
    }

    @Override
    public synchronized boolean remove(@NotNull URI uri, @NotNull HttpCookie cookie) {
        boolean cookieRemoved;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Set<HttpCookie> targetCookies = this.allCookies.get(uri);
        boolean bl = cookieRemoved = targetCookies != null && targetCookies.remove(cookie);
        if (cookieRemoved) {
            this.removeFromPersistence(uri, cookie);
        }
        return cookieRemoved;
    }

    private final void removeFromPersistence(URI uri, HttpCookie cookieToRemove) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.remove(uri.toString() + '|' + cookieToRemove.getName());
        editor.apply();
    }

    @Override
    public synchronized boolean removeAll() {
        this.allCookies.clear();
        this.removeAllFromPersistence();
        return true;
    }

    private final void removeAllFromPersistence() {
        this.sharedPreferences.edit().clear().apply();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lae/trdqad/base/cookie/PersistentCookieStore$Companion;", "", "()V", "SP_COOKIE_STORE", "", "SP_KEY_DELIMITER", "SP_KEY_DELIMITER_REGEX", "TAG", "kotlin.jvm.PlatformType", "cookieUri", "Ljava/net/URI;", "uri", "cookie", "Ljava/net/HttpCookie;", "base_release"})
    public static final class Companion {
        private Companion() {
        }

        private final URI cookieUri(URI uri, HttpCookie cookie) {
            URI cookieUri = uri;
            if (cookie.getDomain() != null) {
                String domain = cookie.getDomain();
                if (domain.charAt(0) == '.') {
                    String string = domain;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"domain");
                    String string2 = string;
                    int n = 1;
                    String string3 = string2.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    domain = string3;
                }
                try {
                    cookieUri = new URI(uri.getScheme() == null ? "http" : uri.getScheme(), domain, cookie.getPath() == null ? "/" : cookie.getPath(), null);
                }
                catch (URISyntaxException e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
            return cookieUri;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

