/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.base.remote;

import ae.trdqad.base.Logger;
import ae.trdqad.base.cookie.CookieUtils;
import ae.trdqad.base.remote.Response;
import ae.trdqad.base.remote.TradiqueException;
import ae.trdqad.base.remote.TradiqueHardException;
import ae.trdqad.base.utils.UtilsKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java9.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lae/trdqad/base/remote/ApiRequest;", "Ljava9/util/function/Supplier;", "Lae/trdqad/base/remote/Response;", "url", "", "body", "Lorg/json/JSONObject;", "(Ljava/lang/String;Lorg/json/JSONObject;)V", "get", "Companion", "base_release"})
public final class ApiRequest
implements Supplier<Response> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final String body;
    private static final int HTTP_TIMEOUT = 5000;

    public ApiRequest(@NotNull String url, @NotNull JSONObject body) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.url = url;
        String string = body.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body.toString()");
        this.body = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Response get() {
        Response response;
        InputStream is = null;
        OutputStream os = null;
        try {
            String string = "Request url: %s";
            Object object = new Object[]{this.url};
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            Logger.INSTANCE.d(string2);
            URLConnection uRLConnection = new URL(this.url).openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection c = (HttpURLConnection)uRLConnection;
            c.setDoOutput(true);
            c.setUseCaches(false);
            c.setConnectTimeout(5000);
            c.setReadTimeout(5000);
            c.setRequestMethod("POST");
            c.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            c.setRequestProperty("Accept", "application/json");
            CookieUtils.INSTANCE.add(c);
            os = c.getOutputStream();
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray = this.body.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            os.write(byArray);
            object = "Request body: %s";
            Object object2 = new Object[]{this.body};
            String string3 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            Logger.INSTANCE.d(string3);
            int statusCode = c.getResponseCode();
            object2 = "Response status code: %s";
            Object object3 = new Object[]{statusCode};
            String string4 = String.format((String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            Logger.INSTANCE.d(string4);
            CookieUtils.INSTANCE.store(c);
            is = statusCode < 400 ? c.getInputStream() : c.getErrorStream();
            String responseBody = UtilsKt.streamToString(is);
            object3 = "Response body: %s";
            Object[] objectArray = new Object[]{responseBody};
            String string5 = String.format((String)object3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
            Logger.INSTANCE.d(string5);
            String string6 = responseBody;
            if (string6 == null) {
                string6 = "";
            }
            JSONObject data = new JSONObject(string6);
            Map<String, List<String>> map = c.getHeaderFields();
            Intrinsics.checkNotNullExpressionValue(map, (String)"c.headerFields");
            Response response2 = new Response(statusCode, data, map);
            String failureReason = null;
            if (statusCode != 200) {
                StringBuilder sb = new StringBuilder();
                JSONArray errors = data.optJSONArray("errors");
                if (errors != null) {
                    int n = errors.length();
                    for (int i = 0; i < n; ++i) {
                        String error = errors.optString(i);
                        if (error == null) continue;
                        if (((CharSequence)sb).length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(error);
                    }
                }
                String string7 = failureReason = ((CharSequence)sb).length() > 0 ? sb.toString() : "Unspecified reason";
            }
            if (statusCode == 400) {
                throw new TradiqueHardException(failureReason, null, statusCode, 2, null);
            }
            if (statusCode != 200) {
                throw new TradiqueException("Internal error", null, statusCode, 2, null);
            }
            response = response2;
        }
        catch (IOException e) {
            throw new TradiqueException("Network error", e, 408);
        }
        catch (JSONException e) {
            throw new TradiqueHardException("Internal error", e, 415);
        }
        finally {
            UtilsKt.close(is);
            UtilsKt.close(os);
        }
        return response;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lae/trdqad/base/remote/ApiRequest$Companion;", "", "()V", "HTTP_TIMEOUT", "", "base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

