/*
 * Decompiled with CFR 0.152.
 */
package ae.trdqad.base.utils;

import ae.trdqad.base.Logger;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"close", "", "closeable", "Ljava/io/Closeable;", "shouldGetAdvertisingId", "", "context", "Landroid/content/Context;", "streamToString", "", "inputStream", "Ljava/io/InputStream;", "base_release"})
public final class UtilsKt {
    @Nullable
    public static final String streamToString(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(buffer);
            boolean bl = false;
            length = it;
            if (n == -1) break;
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public static final void close(@Nullable Closeable closeable) {
        try {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.d("Failed to close closeable.", e);
        }
    }

    public static final boolean shouldGetAdvertisingId(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.g\u2026ageManager.GET_META_DATA)");
            ApplicationInfo app = applicationInfo;
            bl = app.metaData != null ? app.metaData.getBoolean("ae.trdqad.sdk.TRACK_ADVERTISING_ID", true) : true;
        }
        catch (Exception e) {
            bl = true;
        }
        return bl;
    }
}

