/*
 * Decompiled with CFR 0.152.
 */
package aero.m_click.mcpdf;

import aero.m_click.mcpdf.Config;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.XfdfReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Main {
    public static void main(String[] args) {
        try {
            Main.execute(Main.parseArgs(args));
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("See README for more information.");
            System.exit(1);
        }
    }

    public static Config parseArgs(String[] args) throws FileNotFoundException {
        if (args.length == 0) {
            throw new RuntimeException("Missing arguments.");
        }
        Config config = new Config();
        config.pdfInputStream = new FileInputStream(args[0]);
        config.pdfOutputStream = System.out;
        config.formInputStream = null;
        config.stampFilename = "";
        config.backgroundFilename = "";
        config.flatten = false;
        for (int i = 1; i < args.length; ++i) {
            if ("stamp".equals(args[i])) {
                config.stampFilename = args[++i];
                continue;
            }
            if ("background".equals(args[i])) {
                config.backgroundFilename = args[++i];
                continue;
            }
            if ("fill_form".equals(args[i])) {
                config.formInputStream = System.in;
                if ("-".equals(args[++i])) continue;
                throw new RuntimeException("Missing \"-\" after fill_form operation.");
            }
            if ("output".equals(args[i])) {
                if ("-".equals(args[++i])) continue;
                throw new RuntimeException("Missing \"-\" after output operation.");
            }
            if ("flatten".equals(args[i])) {
                config.flatten = true;
                continue;
            }
            throw new RuntimeException("Unknown operation: " + args[i]);
        }
        return config;
    }

    public static void execute(Config config) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(config.pdfInputStream);
        PdfStamper stamper = new PdfStamper(reader, config.pdfOutputStream, '\u0000');
        if (!config.stampFilename.isEmpty()) {
            Main.stampBackground(reader, stamper, config.stampFilename, true);
        }
        if (!config.backgroundFilename.isEmpty()) {
            Main.stampBackground(reader, stamper, config.backgroundFilename, false);
        }
        if (config.formInputStream != null) {
            stamper.getAcroFields().setFields(new XfdfReader(config.formInputStream));
        }
        stamper.setFormFlattening(config.flatten);
        stamper.close();
    }

    public static void stampBackground(PdfReader reader, PdfStamper stamper, String signature, boolean isStamp) throws IOException, DocumentException {
        int num_pages = reader.getNumberOfPages();
        PdfReader r = new PdfReader(signature);
        PdfImportedPage page = stamper.getImportedPage(r, 1);
        for (int i = 1; i <= num_pages; ++i) {
            PdfContentByte canvas = isStamp ? stamper.getOverContent(i) : stamper.getUnderContent(i);
            canvas.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
        }
        stamper.getWriter().freeReader(r);
    }
}

