/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes;

import aero.t2s.modes.Acas;
import aero.t2s.modes.Altitude;
import aero.t2s.modes.CapabilityReport;
import aero.t2s.modes.CprPosition;
import aero.t2s.modes.FlightStatus;
import aero.t2s.modes.Meteo;
import aero.t2s.modes.RadiusLimit;
import aero.t2s.modes.constants.EmergencyState;
import aero.t2s.modes.constants.LengthWidthCode;
import aero.t2s.modes.constants.SelectedAltitudeSource;
import aero.t2s.modes.constants.Version;
import java.time.Instant;

public class Track {
    private String icao;
    private String callsign;
    private int category;
    private boolean groundBit;
    private int baroAltitude;
    private int gnssHeight;
    private double lat;
    private double lon;
    private CprPosition cprPositionEven = new CprPosition();
    private CprPosition cprPositionOdd = new CprPosition();
    Instant updated = Instant.now();
    private boolean singleAntenna;
    private int NIC;
    private int NICb;
    private int NICa;
    private int NICc;
    private RadiusLimit rc = new RadiusLimit(this);
    private int NACv;
    private boolean spi;
    private boolean tempAlert;
    private boolean emergency;
    private Version version = Version.VERSION0;
    private Acas acas = new Acas();
    private FlightStatus flightStatus = new FlightStatus();
    private Altitude altitude = new Altitude();
    private SelectedAltitudeSource selectedAltitudeSource = SelectedAltitudeSource.UNKNOWN;
    private Meteo meteo = new Meteo();
    private CapabilityReport capabilityReport = new CapabilityReport();
    private int modeA;
    private int geometricHeightOffset;
    private int rocd;
    private boolean rocdAvailable;
    private boolean rocdSourceBaro;
    private int vx;
    private int vy;
    private double gs;
    private boolean headingSourceMagnetic;
    private double magneticHeading;
    private double trueHeading;
    private boolean iasAvailable;
    private int ias;
    private double tas;
    private boolean selectedAltitudeManagedFms;
    private boolean selectedAltitudeManagedMcp;
    private int selectedAltitude;
    private double baroSetting;
    private double selectedHeading;
    private boolean validStatus;
    private int sil;
    private boolean autopilot;
    private boolean vnav;
    private boolean altitudeHold;
    private boolean approachMode;
    private boolean lnav;
    private LengthWidthCode lengthWidthCode = LengthWidthCode.CAT15;
    private EmergencyState emergencyState = EmergencyState.NONE;
    private int fmsSelectedAltitude;
    private double rollAngle;
    private double trackAngleRate;
    private double mach;
    private double baroRocd;
    private String atype = "";
    private String wtc = "";
    private String registration;
    private String operator;
    private boolean wasJustCreated = true;

    public Track(String icao) {
        this.icao = icao;
    }

    public void setCallsign(String callsign) {
        this.callsign = callsign;
    }

    public String getCallsign() {
        return this.callsign;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public String getIcao() {
        return this.icao;
    }

    public boolean isExpired() {
        return Instant.now().minusSeconds(15L).isAfter(this.updated);
    }

    public Instant getUpdatedAt() {
        return this.updated;
    }

    public void touch() {
        this.updated = Instant.now();
    }

    public void setGroundBit(boolean groundBit) {
        this.groundBit = groundBit;
    }

    public boolean isGroundBit() {
        return this.groundBit;
    }

    public void setBaroAltitude(int baroAltitude) {
        this.baroAltitude = baroAltitude;
    }

    public int getBaroAltitude() {
        return this.baroAltitude;
    }

    public int getGnssHeight() {
        return this.gnssHeight;
    }

    public Track setGnssHeight(int gnssHeight) {
        this.gnssHeight = gnssHeight;
        return this;
    }

    public CprPosition getCprPosition(boolean cprEven) {
        return cprEven ? this.cprPositionEven : this.cprPositionOdd;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public double getLon() {
        return this.lon;
    }

    public void setSingleAntenna(boolean singleAntenna) {
        this.singleAntenna = singleAntenna;
    }

    public boolean getSingleAntenna() {
        return this.singleAntenna;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public int getNIC() {
        return this.NIC;
    }

    public int getNICa() {
        return this.NICa;
    }

    public int getNICb() {
        return this.NICb;
    }

    public int getNICc() {
        return this.NICc;
    }

    public void setNIC(int NIC) {
        if (this.NIC != NIC) {
            this.NIC = NIC;
            this.rc.determine();
        }
    }

    public void setNICa(int NICa) {
        if (this.NICa != NICa) {
            this.NICa = NICa;
            this.rc.determine();
        }
    }

    public void setNICb(int niCb) {
        if (niCb != this.NICb) {
            this.NICb = niCb;
            this.rc.determine();
        }
    }

    public void setNICc(int NICc) {
        if (this.NICc != NICc) {
            this.NICc = NICc;
            this.rc.determine();
        }
    }

    public void setSpi(boolean spi) {
        this.spi = spi;
    }

    public boolean getSpi() {
        return this.spi;
    }

    public void setTempAlert(boolean tempAlert) {
        this.tempAlert = tempAlert;
    }

    public boolean getTempAlert() {
        return this.tempAlert;
    }

    public void setEmergency(boolean emergency) {
        this.emergency = emergency;
    }

    public boolean getEmergency() {
        return this.emergency;
    }

    public Acas getAcas() {
        return this.acas;
    }

    public void setAcas(Acas acas) {
        this.acas = acas;
    }

    public FlightStatus getFlightStatus() {
        return this.flightStatus;
    }

    public void setFlightStatus(FlightStatus flightStatus) {
        this.flightStatus = flightStatus;
    }

    public void setAltitude(Altitude altitude) {
        this.altitude = altitude;
    }

    public Altitude getAltitude() {
        return this.altitude;
    }

    public void setModeA(int modeA) {
        this.modeA = modeA;
    }

    public int getModeA() {
        return this.modeA;
    }

    public boolean isPositionAvailable() {
        return this.lat != 0.0 & this.lon != 0.0;
    }

    public void setNACv(int naCv) {
        this.NACv = naCv;
    }

    public int getNACv() {
        return this.NACv;
    }

    public void setGeometricHeightOffset(int geometricHeightOffset) {
        this.geometricHeightOffset = geometricHeightOffset;
    }

    public int getGeometricHeightOffset() {
        return this.geometricHeightOffset;
    }

    public void setRocd(int rocd) {
        this.rocd = rocd;
    }

    public int getRocd() {
        return this.rocd;
    }

    public void setRocdAvailable(boolean rocdAvailable) {
        this.rocdAvailable = rocdAvailable;
    }

    public boolean getRocdAvailable() {
        return this.rocdAvailable;
    }

    public void setRocdSourceBaro(boolean rocdSourceBaro) {
        this.rocdSourceBaro = rocdSourceBaro;
    }

    public boolean getRocdSourceBaro() {
        return this.rocdSourceBaro;
    }

    public void setVx(int vx) {
        this.vx = vx;
    }

    public int getVx() {
        return this.vx;
    }

    public void setVy(int vy) {
        this.vy = vy;
    }

    public int getVy() {
        return this.vy;
    }

    public void setGs(double gs) {
        this.gs = gs;
    }

    public double getGs() {
        return this.gs;
    }

    public boolean isMagneticHeading() {
        return this.headingSourceMagnetic;
    }

    public void setHeadingSource(boolean magneticHeading) {
        this.headingSourceMagnetic = magneticHeading;
    }

    public void setMagneticHeading(double magneticHeading) {
        this.magneticHeading = magneticHeading;
    }

    public double getMagneticHeading() {
        return this.magneticHeading;
    }

    public void setTrueHeading(double trueHeading) {
        this.trueHeading = trueHeading;
    }

    public double getTrueHeading() {
        return this.trueHeading;
    }

    public void setIasAvailable(boolean iasAvailable) {
        this.iasAvailable = iasAvailable;
    }

    public boolean isIasAvailable() {
        return this.iasAvailable;
    }

    public void setIas(int ias) {
        this.ias = ias;
    }

    public int getIas() {
        return this.ias;
    }

    public void setTas(double tas) {
        this.tas = tas;
    }

    public double getTas() {
        return this.tas;
    }

    public void setSelectedAltitudeManagedFms(boolean selectedAltitudeManagedFms) {
        this.selectedAltitudeManagedFms = selectedAltitudeManagedFms;
    }

    public boolean getSelectedAltitudeManagedFms() {
        return this.selectedAltitudeManagedFms;
    }

    public void setSelectedAltitudeManagedMcp(boolean selectedAltitudeManagedMcp) {
        this.selectedAltitudeManagedMcp = selectedAltitudeManagedMcp;
    }

    public boolean getSelectedAltitudeManagedMcp() {
        return this.selectedAltitudeManagedMcp;
    }

    public void setSelectedAltitude(int selectedAltitude) {
        this.selectedAltitude = selectedAltitude;
    }

    public int getSelectedAltitude() {
        return this.selectedAltitude;
    }

    public void setBaroSetting(double baroSetting) {
        this.baroSetting = baroSetting;
    }

    public double getBaroSetting() {
        return this.baroSetting;
    }

    public void setSelectedHeading(double selectedHeading) {
        this.selectedHeading = selectedHeading;
    }

    public double getSelectedHeading() {
        return this.selectedHeading;
    }

    public void setValidStatus(boolean validStatus) {
        this.validStatus = validStatus;
    }

    public boolean getValidStatus() {
        return this.validStatus;
    }

    public void setSil(int sil) {
        this.sil = sil;
    }

    public int getSil() {
        return this.sil;
    }

    public void setAutopilot(boolean autopilot) {
        this.autopilot = autopilot;
    }

    public boolean getAutopilot() {
        return this.autopilot;
    }

    public void setVnav(boolean vnav) {
        this.vnav = vnav;
    }

    public boolean getVnav() {
        return this.vnav;
    }

    public void setAltitudeHold(boolean altitudeHold) {
        this.altitudeHold = altitudeHold;
    }

    public boolean getAltitudeHold() {
        return this.altitudeHold;
    }

    public void setApproachMode(boolean approachMode) {
        this.approachMode = approachMode;
    }

    public boolean getApproachMode() {
        return this.approachMode;
    }

    public void setLnav(boolean lnav) {
        this.lnav = lnav;
    }

    public boolean getLnav() {
        return this.lnav;
    }

    public void setLengthWidthCode(LengthWidthCode lengthWidthCode) {
        this.lengthWidthCode = lengthWidthCode;
    }

    public LengthWidthCode getLengthWidthCode() {
        return this.lengthWidthCode;
    }

    public void setEmergencyState(EmergencyState emergencyState) {
        this.emergencyState = emergencyState;
    }

    public EmergencyState getEmergencyState() {
        return this.emergencyState;
    }

    public void setFmsSelectedAltitude(int fmsSelectedAltitude) {
        this.fmsSelectedAltitude = fmsSelectedAltitude;
    }

    public int getFmsSelectedAltitude() {
        return this.fmsSelectedAltitude;
    }

    public void setSelectedAltitudeSource(SelectedAltitudeSource selectedAltitudeSource) {
        this.selectedAltitudeSource = selectedAltitudeSource;
    }

    public SelectedAltitudeSource getSelectedAltitudeSource() {
        return this.selectedAltitudeSource;
    }

    public void setRollAngle(double rollAngle) {
        this.rollAngle = rollAngle;
    }

    public double getRollAngle() {
        return this.rollAngle;
    }

    public void setTrackAngleRate(double trackAngleRate) {
        this.trackAngleRate = trackAngleRate;
    }

    public double getTrackAngleRate() {
        return this.trackAngleRate;
    }

    public void setMach(double mach) {
        this.mach = mach;
    }

    public double getMach() {
        return this.mach;
    }

    public void setBaroRocd(double baroRocd) {
        this.baroRocd = baroRocd;
    }

    public double getBaroRocd() {
        return this.baroRocd;
    }

    public String getAtype() {
        return this.atype;
    }

    public Track setAtype(String atype) {
        this.atype = atype;
        return this;
    }

    public String getWtc() {
        return this.wtc;
    }

    public Track setWtc(String wtc) {
        this.wtc = wtc;
        return this;
    }

    public void setRegistration(String registration) {
        this.registration = registration;
    }

    public String getRegistration() {
        return this.registration;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public boolean wasJustCreated() {
        return this.wasJustCreated;
    }

    public void setWasJustCreated(boolean state) {
        this.wasJustCreated = state;
    }

    public Meteo getMeteo() {
        return this.meteo;
    }

    public CapabilityReport getCapabilityReport() {
        return this.capabilityReport;
    }

    public String toString() {
        return String.format("%8s(%s) | %6.0f%s | %4.0fft/min| %4.0fKT | LAT: %02.4f LON: %03.4f", this.callsign != null ? this.callsign : "", this.icao, this.altitude.getAltitude(), this.altitude.isMetric() ? "M " : "FT", Float.valueOf(this.rocdAvailable ? (float)this.rocd : 0.0f), this.gs, this.lat, this.lon);
    }
}

