/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.constants;

public class ResolutionAdvisory {
    private boolean requiresCorrectionUpwards;
    private boolean requiresPositiveClimb;
    private boolean requiresCorrectionDownwards;
    private boolean requiresPositiveDescend;
    private boolean requiresCrossing;
    private boolean senseReversal;
    private boolean active;

    public void update(int ara) {
        this.requiresCorrectionUpwards = ara >>> 12 == 1;
        this.requiresPositiveClimb = ara >>> 11 == 1;
        this.requiresCorrectionDownwards = ara >>> 10 == 1;
        this.requiresPositiveDescend = ara >>> 9 == 1;
        this.requiresCrossing = ara >>> 8 == 1;
        boolean bl = this.senseReversal = ara >>> 7 == 1;
        if (!this.active && ara >>> 13 == 1) {
            this.active = true;
        }
    }

    public void clear() {
        this.requiresCorrectionUpwards = false;
        this.requiresPositiveClimb = false;
        this.requiresCorrectionDownwards = false;
        this.requiresPositiveDescend = false;
        this.requiresCrossing = false;
        this.senseReversal = false;
        this.active = false;
    }

    public boolean requiresCorrectionUpwards() {
        return this.requiresCorrectionUpwards;
    }

    public boolean ruquiresPositiveClimb() {
        return this.requiresPositiveClimb;
    }

    public boolean requiresCorrectionDownwards() {
        return this.requiresCorrectionDownwards;
    }

    public boolean requiresPositiveDescend() {
        return this.requiresPositiveDescend;
    }

    public boolean requiresCrossing() {
        return this.requiresCrossing;
    }

    public boolean senseReversal() {
        return this.senseReversal;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String toString() {
        String out = "\n";
        if (this.requiresCorrectionUpwards) {
            out = out + " - RA requires a correction in the upward sense";
        }
        if (this.requiresPositiveClimb) {
            out = out + " - RA requires a positive climb";
        }
        if (this.requiresCorrectionDownwards) {
            out = out + " - RA requires a correction in the downward sense";
        }
        if (this.requiresPositiveDescend) {
            out = out + " - RA requires a positive descend";
        }
        if (this.requiresCrossing) {
            out = out + " - RA requires a crossing";
        }
        if (this.senseReversal) {
            out = out + " - RA is a sense reversal";
        }
        return out;
    }
}

