/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.SelectedAltitudeSource;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds40
extends Bds {
    @Override
    public boolean attemptDecode(Track track, short[] data) {
        boolean reservedZeroB;
        boolean mcpStatus = data[4] >>> 7 == 1;
        boolean fmsStatus = (data[5] >>> 2 & 1) == 1;
        boolean baroStatus = (data[7] >>> 5 & 1) == 1;
        boolean mcpModeStatus = (data[9] & 1) == 1;
        boolean targetSource = (data[10] >>> 2 & 1) == 1;
        boolean reservedZeroA = (data[8] & 1 | data[9] >>> 1) == 0;
        boolean bl = reservedZeroB = (data[10] >>> 3 & 3) == 0;
        if (!reservedZeroA) {
            return false;
        }
        if (!reservedZeroB) {
            return false;
        }
        int mcpFcuAltitude = ((data[4] & 0x7F) << 5 | data[6] >> 3) * 16;
        if (mcpStatus && mcpFcuAltitude > 50000) {
            return false;
        }
        int fmsAltitude = ((data[5] & 3) << 10 | data[6] << 2 | data[7] >>> 6 & 3) * 16;
        if (fmsStatus && (fmsAltitude <= 0 || fmsAltitude > 50000)) {
            return false;
        }
        double baro = (double)((data[7] & 0x1F) << 7 | data[8] >>> 1) * 0.1 + 800.0;
        if (baroStatus && (baro < 850.0 || baro > 1100.0)) {
            return false;
        }
        if (mcpStatus) {
            track.setSelectedAltitude(mcpFcuAltitude);
        }
        if (fmsStatus) {
            track.setFmsSelectedAltitude(fmsAltitude);
        }
        if (baroStatus) {
            track.setBaroSetting(baro);
        }
        if (mcpModeStatus) {
            track.setVnav(data[10] >>> 7 == 1);
            track.setAltitudeHold((data[10] >>> 6 & 1) == 1);
            track.setApproachMode((data[10] >>> 5 & 1) == 1);
        }
        if (targetSource) {
            track.setSelectedAltitudeSource(SelectedAltitudeSource.find(data[10] & 3));
        }
        return true;
    }
}

