/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Meteo;
import aero.t2s.modes.Track;
import aero.t2s.modes.constants.Hazard;
import aero.t2s.modes.constants.MeteoSource;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds44
extends Bds {
    private static final double WIND_DIRECTION_ACCURACY = 0.703125;
    private static final double SAT_ACCURACY = 0.25;
    private static final double HUMIDITY_ACCURACY = 1.5625;

    @Override
    public boolean attemptDecode(Track track, short[] data) {
        if (!track.getCapabilityReport().isBds44()) {
            return false;
        }
        MeteoSource source = MeteoSource.find(data[4] >>> 4);
        if (source == MeteoSource.INVALID || source == MeteoSource.RESERVED) {
            return false;
        }
        boolean windSpeedStatus = (data[4] & 8) != 0;
        int windSpeed = (data[4] & 7) << 6 | data[5] >> 2;
        double windDirection = (double)((data[5] & 3) << 7 | data[6] >> 1) * 0.703125;
        if (!windSpeedStatus && windSpeed != 0) {
            return false;
        }
        if (windSpeedStatus && windSpeed > 250) {
            return false;
        }
        boolean isSatNegative = (data[6] & 1) == 1;
        double sat = (double)(data[7] << 2 | data[8] >>> 6) * 0.25 * (double)(isSatNegative ? -1 : 1);
        if (sat > 60.0 || sat < -80.0) {
            return false;
        }
        boolean averageStaticPressureStatus = (data[8] & 0x20) != 0;
        int averageStaticPressure = (data[8] & 0x1F) << 6 | data[9] >> 2;
        if (!averageStaticPressureStatus && averageStaticPressure != 0) {
            return false;
        }
        boolean turbulenceStatus = (data[9] & 2) != 0;
        Hazard turbulence = Hazard.find((data[9] & 1) << 1 | data[10] >>> 7);
        if (!turbulenceStatus && turbulence != Hazard.NIL) {
            return false;
        }
        boolean humidityStatus = (data[10] & 0x40) != 0;
        double humidity = (double)(data[10] & 0x3F) * 1.5625;
        if (!humidityStatus && humidity != 0.0) {
            return false;
        }
        Meteo meteo = track.getMeteo();
        if (windSpeedStatus) {
            meteo.setWindSpeed(windSpeed);
            meteo.setWindDirection(windDirection);
        }
        if (averageStaticPressureStatus) {
            meteo.setAverageStaticPressure(averageStaticPressure);
        }
        if (turbulenceStatus) {
            meteo.setTurbulence(turbulence);
        }
        meteo.setStaticAirTemperature(sat);
        if (humidityStatus) {
            meteo.setHumidity(humidity);
        }
        return true;
    }
}

