/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds60
extends Bds {
    private static final double MAG_ACCURACY = 0.17578125;
    private static final double MACH_ACCURACY = 4.0;
    private static final double ROCD_ACCURCY = 32.0;

    @Override
    public boolean attemptDecode(Track track, short[] data) {
        if (!track.getCapabilityReport().isBds60()) {
            return false;
        }
        boolean statusMagHdg = (data[4] >>> 7 & 1) == 1;
        boolean statusIas = (data[5] >>> 4 & 1) == 1;
        boolean statusMach = (data[6] & 1) == 1;
        boolean statusBaroRocd = (data[8] >>> 5 & 1) == 1;
        boolean statusIrsRocd = (data[9] >>> 2 & 1) == 1;
        double hdgSign = (data[4] >>> 6 & 1) == 1 ? -1024.0 : 0.0;
        double magHdg = ((double)((data[4] & 0x3F) << 4 | data[5] >>> 4) + hdgSign) * 0.17578125;
        if (magHdg < 0.0) {
            magHdg += 360.0;
        }
        if (statusMagHdg && (magHdg <= 0.0 || magHdg > 360.0)) {
            return false;
        }
        int ias = (data[5] & 7) << 7 | data[6] >>> 1;
        if (statusIas && (ias <= 0 || ias > 512)) {
            return false;
        }
        double mach = (double)(data[7] << 2 | data[8] >> 6) * 4.0;
        mach /= 1000.0;
        if (statusMach && (mach <= 0.0 || mach > 1.0)) {
            return false;
        }
        double baroSign = (data[8] >>> 4 & 1) == 1 ? -512.0 : 0.0;
        double baroRocd = ((double)((data[8] & 0xF) << 5 | data[9] >>> 3) + baroSign) * 32.0;
        if (statusBaroRocd && (baroRocd < -8000.0 || baroRocd > 8000.0)) {
            return false;
        }
        double irsSign = (data[9] >> 1 & 1) == 1 ? -512.0 : 0.0;
        double irsRocd = ((double)((data[9] & 1) << 8 | data[10]) + irsSign) * 32.0;
        if (statusIrsRocd && (irsRocd < -8000.0 || irsRocd > 6000.0)) {
            return false;
        }
        track.setMagneticHeading(magHdg);
        track.setIas(ias);
        track.setMach(mach);
        track.setBaroRocd(baroRocd);
        track.setRocd((int)irsRocd);
        track.setRocdAvailable(true);
        track.setRocdSourceBaro(!statusIrsRocd);
        return true;
    }
}

