/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.df.df17.ExtendedSquitter;

public class TargetStatusMessage
extends ExtendedSquitter {
    private static final double HEADING_RESOLUTION = 0.703125;

    @Override
    public void decode(Track track, int typeCode, short[] data) {
        int subtype = data[4] >>> 1 & 3;
        if (subtype != 1) {
            return;
        }
        int silSupplement = data[4] & 1;
        boolean selectedAltitudeFms = data[5] >>> 7 == 1;
        int selectedAltitude = ((data[5] & 0x7F) << 4 | (data[6] >>> 4) - 2) * 32;
        track.setSelectedAltitudeManagedFms(selectedAltitudeFms);
        track.setSelectedAltitudeManagedMcp(!selectedAltitudeFms);
        track.setSelectedAltitude(selectedAltitude);
        double baroSetting = (double)(((data[6] & 0xF) << 5 | data[7] >>> 3) - 2) * 0.8 + 800.0;
        track.setBaroSetting(baroSetting);
        track.setValidStatus((data[7] >>> 2 & 1) == 1);
        double headingSign = (data[7] >>> 1 & 1) == 0 ? 1.0 : -1.0;
        double heading = (double)((data[7] & 1) << 7 | data[8] >>> 1) * 0.703125 * headingSign;
        heading = (heading + 360.0) % 360.0;
        track.setSelectedHeading(heading);
        track.setNICb(data[9] >>> 4 & 1);
        track.setSil(data[9] >>> 2 & 3);
        track.setAutopilot((data[9] & 1) == 1);
        track.setVnav(data[10] >>> 7 == 1);
        track.setAltitudeHold((data[10] >>> 6 & 1) == 1);
        track.setApproachMode((data[10] >>> 4 & 1) == 1);
        track.getAcas().setActive((data[10] >>> 3 & 1) == 1);
        track.setLnav((data[10] >>> 2 & 1) == 1);
    }
}

