/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes;

import aero.t2s.modes.ModeSListener;
import aero.t2s.modes.ModeSMessageHandler;
import aero.t2s.modes.Track;
import aero.t2s.modes.database.ModeSDatabase;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ModeS {
    private final ModeSListener listener;
    private final Map<String, Track> tracks = new ConcurrentHashMap<String, Track>();
    private final ModeSMessageHandler handler;
    private Consumer<Track> onTrackDeleted = track -> {};
    private Consumer<Track> onTrackUpdated = track -> {};
    private Consumer<Track> onTrackCreated = track -> {};

    public ModeS(String host, int port, double originLat, double originLon) {
        this(host, port, originLat, originLon, null);
    }

    public ModeS(String host, int port, double originLat, double originLon, ModeSDatabase database) {
        this.handler = new ModeSMessageHandler(this.tracks, originLat, originLon, database);
        this.handler.onTrackCreated(this.onTrackCreated);
        this.handler.onTrackCreated(this.onTrackUpdated);
        this.handler.onTrackCreated(this.onTrackDeleted);
        this.listener = new ModeSListener(new InetSocketAddress(host, port), this.handler);
    }

    public void onTrackDeleted(Consumer<Track> consumer) {
        this.handler.onTrackDeleted(consumer);
    }

    public void onTrackCreated(Consumer<Track> consumer) {
        this.handler.onTrackCreated(consumer);
    }

    public void onTrackUpdated(Consumer<Track> consumer) {
        this.handler.onTrackUpdated(consumer);
    }

    public void start() {
        this.listener.start();
    }

    public void stop() {
        this.listener.interrupt();
    }

    public Map<String, Track> getTracks() {
        return this.tracks;
    }
}

