/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes;

import aero.t2s.modes.BinaryHelper;
import aero.t2s.modes.Track;
import aero.t2s.modes.database.ModeSDatabase;
import aero.t2s.modes.decoder.Decoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

class ModeSMessageHandler {
    private final Decoder decoder;
    private final Executor executor = Executors.newSingleThreadExecutor();
    private Consumer<Track> onDeleted = track -> {};
    private Consumer<Track> onCreated = track -> {};
    private Consumer<Track> onUpdated = track -> {};

    ModeSMessageHandler(final Map<String, Track> tracks, double originLat, double originLon, ModeSDatabase database) {
        this.decoder = new Decoder(tracks, originLat, originLon, database);
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ArrayList expired = new ArrayList();
                tracks.values().stream().filter(Track::isExpired).forEach(track -> expired.add(track.getIcao()));
                expired.forEach(icao -> ModeSMessageHandler.this.onDeleted.accept((Track)tracks.remove(icao)));
            }
        }, 1000L, 5000L);
    }

    void handle(String input) {
        this.executor.execute(() -> {
            String hex = input.substring(1, input.length() - 1);
            short[] data = BinaryHelper.stringToByteArray(hex);
            Track track = this.decoder.decode(data[0] >>> 3, data);
            if (track != null) {
                track.touch();
                if (track.wasJustCreated()) {
                    this.onCreated.accept(track);
                } else {
                    this.onUpdated.accept(track);
                }
            }
        });
    }

    public void onTrackDeleted(Consumer<Track> onDeleted) {
        this.onDeleted = onDeleted;
    }

    public void onTrackUpdated(Consumer<Track> onUpdated) {
        this.onUpdated = onUpdated;
    }

    public void onTrackCreated(Consumer<Track> onCreated) {
        this.onCreated = onCreated;
    }
}

