/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder;

import aero.t2s.modes.Track;
import aero.t2s.modes.database.ModeSDatabase;
import aero.t2s.modes.decoder.Common;
import aero.t2s.modes.decoder.df.DF0;
import aero.t2s.modes.decoder.df.DF11;
import aero.t2s.modes.decoder.df.DF16;
import aero.t2s.modes.decoder.df.DF17;
import aero.t2s.modes.decoder.df.DF18;
import aero.t2s.modes.decoder.df.DF20;
import aero.t2s.modes.decoder.df.DF21;
import aero.t2s.modes.decoder.df.DF22;
import aero.t2s.modes.decoder.df.DF24;
import aero.t2s.modes.decoder.df.DF4;
import aero.t2s.modes.decoder.df.DF5;
import aero.t2s.modes.decoder.df.DownlinkFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decoder {
    private static final Logger logger = LoggerFactory.getLogger(Decoder.class);
    private ModeSDatabase modeSDatabase;
    private Map<String, Track> tracks;
    private Map<Integer, DownlinkFormat> downlinkFormatDecoders = new HashMap<Integer, DownlinkFormat>();

    public Decoder(Map<String, Track> tracks, double originLat, double originLon, ModeSDatabase database) {
        this.tracks = tracks;
        if (database == null) {
            database = ModeSDatabase.createDatabase();
        }
        this.modeSDatabase = database;
        this.downlinkFormatDecoders.put(0, new DF0(this));
        this.downlinkFormatDecoders.put(4, new DF4(this));
        this.downlinkFormatDecoders.put(5, new DF5(this));
        this.downlinkFormatDecoders.put(11, new DF11(this));
        this.downlinkFormatDecoders.put(16, new DF16(this));
        this.downlinkFormatDecoders.put(17, new DF17(this, originLat, originLon));
        this.downlinkFormatDecoders.put(18, new DF18(this));
        this.downlinkFormatDecoders.put(20, new DF20(this));
        this.downlinkFormatDecoders.put(21, new DF21(this));
        this.downlinkFormatDecoders.put(22, new DF22(this));
        this.downlinkFormatDecoders.put(24, new DF24(this));
    }

    public Track decode(int downlinkFormat, short[] data) {
        if (Common.isValid(data)) {
            return null;
        }
        if (downlinkFormat >= 24) {
            downlinkFormat = 24;
        }
        if (this.downlinkFormatDecoders.containsKey(downlinkFormat)) {
            return this.downlinkFormatDecoders.get(downlinkFormat).decode(data, downlinkFormat);
        }
        logger.warn("Unknown Mode S Packet: {} => {}", (Object)downlinkFormat, (Object)Common.toHexString(data));
        return null;
    }

    public Track getTrack(String icao) {
        Track track = this.tracks.get(icao);
        if (track == null) {
            track = new Track(icao);
            this.tracks.putIfAbsent(icao, track);
            ModeSDatabase.ModeSAircraft modeSAircraft = this.modeSDatabase.find(icao);
            if (modeSAircraft != null) {
                track.setWtc(modeSAircraft.wtc);
                track.setAtype(modeSAircraft.atyp);
                track.setOperator(modeSAircraft.operator);
                track.setRegistration(modeSAircraft.registration);
            }
        } else {
            track.setWasJustCreated(false);
        }
        return track;
    }
}

