/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.Decoder;
import aero.t2s.modes.decoder.df.DownlinkFormat;
import aero.t2s.modes.decoder.df.df17.AirbornePosition;
import aero.t2s.modes.decoder.df.df17.AirborneVelocity;
import aero.t2s.modes.decoder.df.df17.AircraftIdentification;
import aero.t2s.modes.decoder.df.df17.AircraftOperationalStatusMessage;
import aero.t2s.modes.decoder.df.df17.AircraftStatusMessage;
import aero.t2s.modes.decoder.df.df17.ExtendedSquitter;
import aero.t2s.modes.decoder.df.df17.ReservedMessage;
import aero.t2s.modes.decoder.df.df17.SurfacePosition;
import aero.t2s.modes.decoder.df.df17.SurfaceSystemStatus;
import aero.t2s.modes.decoder.df.df17.TargetStatusMessage;
import aero.t2s.modes.decoder.df.df17.TestMessage;
import java.util.HashMap;
import java.util.Map;

public class DF17
extends DownlinkFormat {
    private Map<Integer, ExtendedSquitter> squitterMap = new HashMap<Integer, ExtendedSquitter>();

    public DF17(Decoder decoder, double originLat, double originLon) {
        super(decoder);
        AircraftIdentification aircraftIdentification = new AircraftIdentification();
        AirbornePosition airbornePosition = new AirbornePosition(originLat, originLon);
        SurfacePosition surfacePosition = new SurfacePosition();
        ReservedMessage reservedMessage = new ReservedMessage();
        this.squitterMap.put(0, airbornePosition);
        this.squitterMap.put(1, aircraftIdentification);
        this.squitterMap.put(2, aircraftIdentification);
        this.squitterMap.put(3, aircraftIdentification);
        this.squitterMap.put(4, aircraftIdentification);
        this.squitterMap.put(5, surfacePosition);
        this.squitterMap.put(6, surfacePosition);
        this.squitterMap.put(7, surfacePosition);
        this.squitterMap.put(8, surfacePosition);
        this.squitterMap.put(9, airbornePosition);
        this.squitterMap.put(10, airbornePosition);
        this.squitterMap.put(11, airbornePosition);
        this.squitterMap.put(12, airbornePosition);
        this.squitterMap.put(13, airbornePosition);
        this.squitterMap.put(14, airbornePosition);
        this.squitterMap.put(15, airbornePosition);
        this.squitterMap.put(16, airbornePosition);
        this.squitterMap.put(17, airbornePosition);
        this.squitterMap.put(18, airbornePosition);
        this.squitterMap.put(19, new AirborneVelocity());
        this.squitterMap.put(20, airbornePosition);
        this.squitterMap.put(21, airbornePosition);
        this.squitterMap.put(22, airbornePosition);
        this.squitterMap.put(23, new TestMessage());
        this.squitterMap.put(24, new SurfaceSystemStatus());
        this.squitterMap.put(25, reservedMessage);
        this.squitterMap.put(26, reservedMessage);
        this.squitterMap.put(27, reservedMessage);
        this.squitterMap.put(28, new AircraftStatusMessage());
        this.squitterMap.put(29, new TargetStatusMessage());
        this.squitterMap.put(30, reservedMessage);
        this.squitterMap.put(31, new AircraftOperationalStatusMessage());
    }

    @Override
    public Track decode(short[] data, int downlinkFormat) {
        Track track = this.getDecoder().getTrack(this.getIcaoAddress(data));
        int typeCode = data[4] >>> 3;
        if (!this.squitterMap.containsKey(typeCode)) {
            logger.warn("Mode-S: No parser found for DF-17 type code {}. Packet ignored", (Object)typeCode);
            return track;
        }
        this.squitterMap.get(typeCode).decode(track, typeCode, data);
        return track;
    }
}

