/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.AltitudeEncoding;
import aero.t2s.modes.decoder.Common;
import aero.t2s.modes.decoder.Decoder;
import aero.t2s.modes.decoder.df.DF21;
import aero.t2s.modes.decoder.df.DownlinkFormat;
import aero.t2s.modes.decoder.df.bds.BdsDecoder;
import org.slf4j.LoggerFactory;

public class DF20
extends DownlinkFormat {
    private final BdsDecoder bds = new BdsDecoder();

    public DF20(Decoder decoder) {
        super(decoder);
    }

    @Override
    public Track decode(short[] data, int downlinkFormat) {
        Track track = this.getDecoder().getTrack(this.getIcaoAddressFromParity(data));
        int flightStatus = data[0] & 3;
        track.getFlightStatus().setAlert(Common.isFlightStatusAlert(flightStatus));
        track.getFlightStatus().setSpi(Common.isFlightStatusSpi(flightStatus));
        track.setAltitude(AltitudeEncoding.decode((data[2] & 0x1F) << 8 | data[3]));
        if (!this.bds.decode(track, data)) {
            LoggerFactory.getLogger(DF21.class).warn("ADS-B: DF-20 received but could not determine BDS code {}", (Object)Common.toHexString(data));
        }
        return track;
    }
}

