/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.Common;
import aero.t2s.modes.decoder.Decoder;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DownlinkFormat {
    protected static final Logger logger = LoggerFactory.getLogger(DownlinkFormat.class);
    private final Decoder decoder;

    public DownlinkFormat(Decoder decoder) {
        this.decoder = decoder;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public abstract Track decode(short[] var1, int var2);

    protected String getIcaoAddressFromParity(short[] data) {
        short[] payload = Arrays.copyOfRange(data, 0, data.length - 3);
        short[] parity = Arrays.copyOfRange(data, data.length - 3, data.length);
        return Common.getIcaoAddress(payload, parity);
    }

    protected String getIcaoAddress(short[] data) {
        return Common.toHexString(Arrays.copyOfRange(data, 1, 4));
    }
}

