/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Meteo;
import aero.t2s.modes.Track;
import aero.t2s.modes.constants.Hazard;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds45
extends Bds {
    private static final double SAT_ACCURACY = 0.25;
    private static final int RADIO_HEIGHT_ACCURACY = 16;

    @Override
    public boolean attemptDecode(Track track, short[] data) {
        boolean radioHeightStatus;
        boolean turbulenceStatus = data[4] >>> 7 == 1;
        boolean windShearStatus = (data[4] & 0x10) >>> 4 == 1;
        boolean microBurstStatus = (data[4] & 2) >>> 1 == 1;
        boolean icingStatus = (data[5] & 0x40) >>> 6 == 1;
        boolean wakeStatus = (data[5] & 8) >>> 3 == 1;
        boolean satStatus = (data[5] & 1) == 1;
        boolean averageStaticPressureStatus = (data[7] & 0x20) >>> 5 == 1;
        boolean bl = radioHeightStatus = (data[7] & 2) >>> 1 == 1;
        if ((data[10] & 0x1F) != 0) {
            return false;
        }
        Hazard turbulence = Hazard.find((data[4] & 0x60) >>> 5);
        if (!turbulenceStatus && turbulence != Hazard.NIL) {
            return false;
        }
        Hazard windShear = Hazard.find((data[4] & 0xC) >>> 2);
        if (!windShearStatus && windShear != Hazard.NIL) {
            return false;
        }
        Hazard microBurst = Hazard.find((data[4] & 1) << 1 | data[5] >> 7);
        if (!microBurstStatus && microBurst != Hazard.NIL) {
            return false;
        }
        Hazard icing = Hazard.find((data[5] & 0x30) >>> 4);
        if (!icingStatus && icing != Hazard.NIL) {
            return false;
        }
        Hazard wake = Hazard.find((data[5] & 6) >>> 1);
        if (!wakeStatus && wake != Hazard.NIL) {
            return false;
        }
        boolean isSatNegative = data[6] >>> 7 == 1;
        double sat = (double)((data[6] & 0x7F) << 2 | data[7] >>> 6) * 0.25 * (double)(isSatNegative ? -1 : 1);
        if (!satStatus && sat != 0.0) {
            return false;
        }
        if (satStatus && (sat > 60.0 || sat < -80.0)) {
            return false;
        }
        int averageStaticPressure = (data[7] & 0x1F) << 6 | data[8] >>> 2;
        if (!averageStaticPressureStatus && averageStaticPressure != 0) {
            return false;
        }
        int radioHeight = ((data[8] & 1) << 11 | data[9] << 3 | data[10] >>> 5) * 16;
        if (!radioHeightStatus && radioHeight != 0) {
            return false;
        }
        Meteo meteo = track.getMeteo();
        if (turbulenceStatus) {
            meteo.setTurbulence(turbulence);
        }
        if (windShearStatus) {
            meteo.setWindShear(windShear);
        }
        if (microBurstStatus) {
            meteo.setMicroBurst(microBurst);
        }
        if (icingStatus) {
            meteo.setIcing(icing);
        }
        if (wakeStatus) {
            meteo.setWake(wake);
        }
        if (satStatus) {
            meteo.setStaticAirTemperature(sat);
        }
        if (averageStaticPressureStatus) {
            meteo.setAverageStaticPressure(averageStaticPressure);
        }
        if (radioHeightStatus) {
            meteo.setRadioHeight(radioHeight);
        }
        return true;
    }
}

