/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds50
extends Bds {
    private static final double ROLL_ACCURACY = 0.17578125;
    private static final double TRUE_TRACK_ANGLE_ACCURACY = 0.17578125;
    private static final double SPEED_ACCURACY = 2.0;
    private static final double TRUE_TRACK_RATE_ACCURACY = 0.03125;

    @Override
    public boolean attemptDecode(Track track, short[] data) {
        boolean statusRollAngle = (data[4] >>> 7 & 1) == 1;
        boolean statusTrackAngle = (data[5] >>> 4 & 1) == 1;
        boolean statusGroundSpeed = (data[6] & 1) == 1;
        boolean statusTrueAngleRate = (data[8] >>> 5 & 1) == 1;
        boolean statusTrueAirspeed = (data[9] >>> 2 & 1) == 1;
        boolean isLeftWingDown = (data[4] >>> 6 & 1) == 1;
        double rollAngle = (double)(((data[4] & 0x3F) << 3 | data[5] >>> 5) - (isLeftWingDown ? 512 : 0)) * 0.17578125;
        if (!statusRollAngle && (isLeftWingDown || rollAngle != 0.0)) {
            return false;
        }
        if (statusRollAngle && Math.abs(rollAngle) > 50.0) {
            return false;
        }
        boolean isWest = (data[5] & 8) != 0;
        int trueTrack = (data[5] & 7) << 7 | data[6] >>> 1;
        if (!statusTrackAngle && (isWest || trueTrack != 0)) {
            return false;
        }
        int gs = data[7] << 2 | data[8] >>> 6 & 3;
        if (!statusGroundSpeed && gs != 0) {
            return false;
        }
        boolean isTrackAngleRateNegative = (data[8] & 0x10) != 0;
        int trackAngleRate = (data[8] & 0xF) << 5 | data[9] >>> 3;
        if (!statusTrueAngleRate && (isTrackAngleRateNegative || trackAngleRate != 0)) {
            return false;
        }
        if (statusTrueAngleRate && trackAngleRate == 255) {
            return false;
        }
        int trueAirspeed = (data[9] & 3) << 8 | data[10];
        if (!statusTrueAirspeed && trueAirspeed != 0) {
            return false;
        }
        if (statusRollAngle) {
            track.setRollAngle(rollAngle);
        }
        if (statusTrackAngle) {
            track.setTrueHeading((double)trueTrack * 0.17578125 + (isWest ? 180.0 : 0.0));
        }
        if (statusGroundSpeed) {
            track.setGs((double)gs * 2.0);
        }
        if (statusTrueAngleRate) {
            track.setTrackAngleRate((double)trackAngleRate * 0.03125 * (isTrackAngleRateNegative ? -1.0 : 1.0));
        }
        if (statusTrueAirspeed) {
            track.setTas((double)trueAirspeed * 2.0);
        }
        return true;
    }
}

