/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds53
extends Bds {
    private static final double HEADING_ACCURACY = 0.17578125;
    private static final double MACH_ACCURACY = 0.008;
    private static final double TAS_ACCURACY = 0.5;
    private static final int VS_ACCURACY = 64;

    @Override
    public boolean attemptDecode(Track track, short[] data) {
        boolean magHdgStatus = (data[4] & 0x80) == 128;
        boolean iasStatus = (data[5] & 8) == 8;
        boolean machStatus = (data[6] & 1) == 1;
        boolean tasStatus = (data[8] & 0x40) == 64;
        boolean vsStatus = (data[9] & 2) == 2;
        boolean isMagHdgNegative = (data[4] & 0x40) == 64;
        double magHdg = (double)((data[4] & 0x3F) << 4 | data[5] & 0xF0) * 0.17578125 + (double)(isMagHdgNegative ? 180 : 0);
        if (!magHdgStatus && magHdg != 0.0 || magHdg > 360.0) {
            return false;
        }
        int ias = (data[5] & 7) << 7 | (data[6] & 0xFE) >>> 1;
        if (!iasStatus && ias != 0) {
            return false;
        }
        if (iasStatus && ias > 500) {
            return false;
        }
        double mach = (double)(data[7] << 1 | data[8] >>> 7) * 0.008;
        if (!machStatus && mach != 0.0) {
            return false;
        }
        double tas = (double)((data[8] & 0x3F) << 6 | (data[9] & 0xFC) >>> 2) * 0.5;
        if (!tasStatus && tas != 0.0) {
            return false;
        }
        if (tasStatus && tas > 500.0) {
            return false;
        }
        boolean isVsNegative = (data[9] & 1) == 1;
        int vs = data[10] * 64 * (isVsNegative ? -1 : 0);
        if (!vsStatus && vs != 0) {
            return false;
        }
        if (magHdgStatus) {
            track.setMagneticHeading(magHdg);
        }
        if (iasStatus) {
            track.setIas(ias);
        }
        if (machStatus) {
            track.setMach(mach);
        }
        if (tasStatus) {
            track.setTas(tas);
        }
        if (vsStatus) {
            track.setRocd(vs);
        }
        return true;
    }
}

