/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.CprPosition;
import aero.t2s.modes.Track;
import aero.t2s.modes.constants.Version;
import aero.t2s.modes.decoder.df.df17.ExtendedSquitter;

public class AirbornePosition
extends ExtendedSquitter {
    private final double originLat;
    private final double originLon;

    public AirbornePosition(double originLat, double originLon) {
        this.originLat = originLat;
        this.originLon = originLon;
    }

    @Override
    public void decode(Track track, int typeCode, short[] data) {
        track.setGroundBit(false);
        int surStatus = data[4] >>> 1 & 3;
        track.setSpi(surStatus == 3);
        track.setTempAlert(surStatus == 2);
        track.setEmergency(surStatus == 1);
        if (track.getVersion().ordinal() < Version.VERSION2.ordinal()) {
            track.setSingleAntenna((data[4] & 1) == 0);
        } else {
            track.setNICb(data[4] & 1);
        }
        track.setNIC(this.determineNIC(track, typeCode));
        int altitude = this.calculateAltitude(data, typeCode);
        if (typeCode < 20) {
            track.setBaroAltitude(altitude);
        } else {
            track.setGnssHeight(altitude);
        }
        if (typeCode == 0) {
            return;
        }
        int time = data[6] >>> 3 & 1;
        boolean cprEven = (data[6] >>> 2 & 1) == 0;
        int cprLat = (data[6] & 3) << 15;
        cprLat |= data[7] << 7;
        int cprLon = (data[8] & 1) << 16;
        cprLon |= data[9] << 8;
        CprPosition cprPosition = track.getCprPosition(cprEven);
        cprPosition.setLat((double)(cprLat |= data[8] >>> 1) / 131072.0);
        cprPosition.setLon((double)(cprLon |= data[10]) / 131072.0);
        cprPosition.setTime(time);
        this.calculatePosition(track, cprEven);
    }

    private int determineNIC(Track track, int typeCode) {
        switch (typeCode) {
            case 9: 
            case 20: {
                return 11;
            }
            case 10: 
            case 21: {
                return 10;
            }
            case 11: {
                if (track.getNICa() == 1 && track.getNICb() == 1) {
                    return 9;
                }
                if (track.getNICa() == 0 && track.getNICb() == 0) {
                    return 8;
                }
                return 0;
            }
            case 12: {
                return 7;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 5;
            }
            case 15: {
                return 4;
            }
            case 16: {
                if (track.getNICa() == 0 && track.getNICb() == 0) {
                    return 2;
                }
                if (track.getNICa() == 1 && track.getNICb() == 1) {
                    return 3;
                }
                return 0;
            }
            case 17: {
                return 1;
            }
        }
        return 0;
    }

    private void calculatePosition(Track track, boolean isEven) {
        CprPosition cprEven = track.getCprPosition(true);
        CprPosition cprOdd = track.getCprPosition(false);
        if (!cprEven.isValid() || !cprOdd.isValid()) {
            this.calculateLocal(track, isEven);
            return;
        }
        this.calculateGlobal(track, cprEven, cprOdd);
    }

    private void calculateLocal(Track track, boolean isEven) {
        boolean isOdd = !isEven;
        CprPosition cpr = track.getCprPosition(isEven);
        double dlat = isOdd ? 6.101694915254237 : 6.0;
        double j = Math.floor(this.originLat / dlat) + Math.floor(this.originLat % dlat / dlat - cpr.getLat() + 0.5);
        double lat = dlat * (j + cpr.getLat());
        double nl = this.NL(lat) - (isOdd ? 1.0 : 0.0);
        double dlon = nl > 0.0 ? 360.0 / nl : 360.0;
        double m = Math.floor(this.originLon / dlon) + Math.floor(this.originLon % dlon / dlon - cpr.getLon() + 0.5);
        double lon = dlon * (m + cpr.getLon());
        track.setLat(lat);
        track.setLon(lon);
    }

    private void calculateGlobal(Track track, CprPosition cprEven, CprPosition cprOdd) {
        double lon;
        double lat;
        double dLat0 = 6.0;
        double dLat1 = 6.101694915254237;
        double j = Math.floor(59.0 * cprEven.getLat() - 60.0 * cprOdd.getLat() + 0.5);
        double latEven = dLat0 * (j % 60.0 + cprEven.getLat());
        double latOdd = dLat1 * (j % 59.0 + cprOdd.getLat());
        if (latEven >= 270.0 && latEven <= 360.0) {
            latEven -= 360.0;
        }
        if (latOdd >= 270.0 && latOdd <= 360.0) {
            latOdd -= 360.0;
        }
        if (this.NL(latEven) != this.NL(latOdd)) {
            return;
        }
        if (cprEven.getTime() > cprOdd.getTime()) {
            double ni = this.cprN(latEven, 0.0);
            double m = Math.floor(cprEven.getLon() * (this.NL(latEven) - 1.0) - cprOdd.getLon() * this.NL(latEven) + 0.5);
            lat = latEven;
            lon = 360.0 / ni * (m % ni + cprEven.getLon());
        } else {
            double ni = this.cprN(latOdd, 1.0);
            double m = Math.floor(cprEven.getLon() * (this.NL(latOdd) - 1.0) - cprOdd.getLon() * this.NL(latOdd) + 0.5);
            lat = latOdd;
            lon = 360.0 / ni * (m % ni + cprOdd.getLon());
        }
        if (lon > 180.0) {
            lon -= 360.0;
        }
        track.setLat(lat);
        track.setLon(lon);
    }

    private double cprN(double lat, double isOdd) {
        double nl = this.NL(lat) - isOdd;
        return nl > 1.0 ? nl : 1.0;
    }

    private double NL(double lat) {
        if (lat == 0.0) {
            return 59.0;
        }
        if (Math.abs(lat) == 87.0) {
            return 2.0;
        }
        if (Math.abs(lat) > 87.0) {
            return 1.0;
        }
        double tmp = 1.0 - (1.0 - Math.cos(0.10471975511965977)) / Math.pow(Math.cos(Math.PI / 180 * Math.abs(lat)), 2.0);
        return Math.floor(Math.PI * 2 / Math.acos(tmp));
    }

    private int calculateAltitude(short[] data, int typeCode) {
        int n = data[5] >>> 1 << 4;
        int qBit = (data[5] & 1) == 1 ? 25 : 100;
        return (n |= data[6] >>> 4) * qBit - 1000;
    }
}

