/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.LengthWidthCode;
import aero.t2s.modes.constants.Version;
import aero.t2s.modes.decoder.df.df17.ExtendedSquitter;

public class AircraftOperationalStatusMessage
extends ExtendedSquitter {
    @Override
    public void decode(Track track, int typeCode, short[] data) {
        int subType = data[4] & 7;
        track.setVersion(Version.from(data[9] >>> 5));
        track.setNICa(data[9] >>> 4 & 1);
        track.setHeadingSource((data[10] >>> 3 & 1) == 1);
        if (subType == 0) {
            this.decodeAirborne(track, data);
            return;
        }
        if (subType == 1) {
            this.decodeSurface(track, data);
        }
    }

    private void decodeSurface(Track track, short[] data) {
        track.setLengthWidthCode(LengthWidthCode.from(data[6] & 0xF));
        track.getAcas().setActive((data[7] >>> 5 & 1) == 1);
        track.setSpi((data[7] >>> 4 & 1) == 1);
        track.setSingleAntenna((data[7] >>> 2 & 1) == 1);
        track.setHeadingSource((data[10] >>> 3 & 1) == 1);
    }

    private void decodeAirborne(Track track, short[] data) {
        track.getAcas().setActive((data[7] >>> 5 & 1) == 1);
        track.setSpi((data[7] >>> 4 & 1) == 1);
        track.setSingleAntenna((data[7] >>> 2 & 1) == 1);
        track.setNICb(data[10] >>> 3 & 1);
    }
}

