/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Acas;
import aero.t2s.modes.Altitude;
import aero.t2s.modes.Track;
import aero.t2s.modes.constants.AcasReplyInformation;
import aero.t2s.modes.constants.AcasSensitivity;
import aero.t2s.modes.constants.CrossLinkCapability;
import aero.t2s.modes.constants.VerticalStatus;
import aero.t2s.modes.decoder.AltitudeEncoding;
import aero.t2s.modes.decoder.df.DownlinkFormat;

public class DF0
extends DownlinkFormat {
    private VerticalStatus verticalStatus;
    private CrossLinkCapability crossLinkCapability;
    private AcasSensitivity sensitivity;
    private AcasReplyInformation replyInformation;
    private Altitude altitude;

    public DF0(short[] data) {
        super(data, DownlinkFormat.IcaoAddress.FROM_PARITY);
    }

    @Override
    public DF0 decode() {
        this.verticalStatus = VerticalStatus.from(this.data[0] >>> 2 & 1);
        this.crossLinkCapability = CrossLinkCapability.from(this.data[0] >>> 1 & 1);
        this.sensitivity = AcasSensitivity.from(this.data[1] >>> 5);
        this.replyInformation = AcasReplyInformation.from((this.data[1] & 7) << 1 | this.data[2] >> 7 & 1);
        this.altitude = AltitudeEncoding.decode((this.data[2] << 8 | this.data[3]) & 0x1FFF);
        return this;
    }

    @Override
    public void apply(Track track) {
        Acas acas = track.getAcas();
        acas.setVerticalStatus(this.verticalStatus);
        acas.setCrossLinkCapability(this.crossLinkCapability);
        acas.setSensitivity(this.sensitivity);
        acas.setReplyInformation(this.replyInformation);
        acas.setAltitude(this.altitude);
        track.setAltitude(this.altitude);
    }

    public VerticalStatus getVerticalStatus() {
        return this.verticalStatus;
    }

    public CrossLinkCapability getCrossLinkCapability() {
        return this.crossLinkCapability;
    }

    public AcasSensitivity getSensitivity() {
        return this.sensitivity;
    }

    public AcasReplyInformation getReplyInformation() {
        return this.replyInformation;
    }

    public Altitude getAltitude() {
        return this.altitude;
    }
}

