/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Altitude;
import aero.t2s.modes.EmptyMessageException;
import aero.t2s.modes.NotImplementedException;
import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.AltitudeEncoding;
import aero.t2s.modes.decoder.Common;
import aero.t2s.modes.decoder.df.DownlinkFormat;
import aero.t2s.modes.decoder.df.bds.Bds;
import aero.t2s.modes.decoder.df.bds.BdsDecoder;
import aero.t2s.modes.decoder.df.bds.MultipleBdsMatchesFoundException;
import java.util.List;

public class DF20
extends DownlinkFormat {
    private Bds bds;
    private boolean alert;
    private boolean spi;
    private Altitude altitude;
    private boolean valid;
    private boolean multipleMatches;
    private List<Bds> matches;

    public DF20(short[] data) {
        super(data, DownlinkFormat.IcaoAddress.FROM_PARITY);
    }

    @Override
    public DF20 decode() {
        int flightStatus = this.data[0] & 3;
        this.alert = Common.isFlightStatusAlert(flightStatus);
        this.spi = Common.isFlightStatusSpi(flightStatus);
        this.altitude = AltitudeEncoding.decode((this.data[2] & 0x1F) << 8 | this.data[3]);
        try {
            this.bds = new BdsDecoder(this.data).decode();
            this.valid = true;
        }
        catch (EmptyMessageException e) {
            this.valid = false;
        }
        catch (MultipleBdsMatchesFoundException e) {
            this.matches = e.getMatches();
            this.multipleMatches = true;
            this.valid = false;
            logger.debug("Multiple matches BDS matches found {}", this.matches.stream().map(bds -> bds.getClass().getSimpleName()).reduce((a, b) -> String.join((CharSequence)", ", a, b)));
        }
        catch (NotImplementedException e) {
            throw new NotImplementedException("ADS-B: DF-20 received but could not determine BDS code " + Common.toHexString(this.data));
        }
        return this;
    }

    @Override
    public void apply(Track track) {
        track.getFlightStatus().setAlert(this.alert);
        track.getFlightStatus().setSpi(this.spi);
        track.setAltitude(this.altitude);
        if (this.valid) {
            this.bds.apply(track);
        }
    }

    public Bds getBds() {
        return this.bds;
    }

    public boolean isAlert() {
        return this.alert;
    }

    public boolean isSpi() {
        return this.spi;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isMultipleMatches() {
        return this.multipleMatches;
    }

    public List<Bds> getMatches() {
        return this.matches;
    }

    public Altitude getAltitude() {
        return this.altitude;
    }
}

