/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.Angle;
import aero.t2s.modes.constants.LengthWidthCode;
import aero.t2s.modes.constants.NavigationIntegrityCategory;
import aero.t2s.modes.constants.SourceIntegrityLevel;
import aero.t2s.modes.constants.SourceIntegrityLevelSupplement;
import aero.t2s.modes.constants.Version;
import aero.t2s.modes.decoder.df.df17.AircraftOperationalStatusVersion2;
import aero.t2s.modes.decoder.df.df17.data.SurfaceCapability;
import aero.t2s.modes.decoder.df.df17.data.SurfaceOperationalMode;

public class AircraftOperationalStatusVersion2Surface
extends AircraftOperationalStatusVersion2 {
    private SurfaceCapability surfaceCapability;
    private SurfaceOperationalMode operationalMode;
    private LengthWidthCode lengthWidthCode;
    private NavigationIntegrityCategory NICp;
    private Angle horizontalSource;
    private SourceIntegrityLevelSupplement SILsupp;
    private SourceIntegrityLevel SIL;
    private Version verison;

    public AircraftOperationalStatusVersion2Surface(short[] data) {
        super(data);
    }

    @Override
    public AircraftOperationalStatusVersion2Surface decode() {
        this.verison = Version.VERSION2;
        this.surfaceCapability = new SurfaceCapability(this.data[5] << 4 | (this.data[6] & 0xF0) >>> 4, this.verison);
        this.lengthWidthCode = LengthWidthCode.from(this.data[6] & 0xF);
        this.operationalMode = new SurfaceOperationalMode(this.data[7] << 8 | this.data[8]);
        this.SIL = SourceIntegrityLevel.from((this.data[10] & 0x30) >>> 4);
        this.SILsupp = SourceIntegrityLevelSupplement.from((this.data[10] & 2) >>> 1);
        int NICsuppA = (this.data[9] & 0x10) >>> 4;
        int NACp = this.data[9] & 0xF;
        this.NICp = NavigationIntegrityCategory.surface(NACp, NICsuppA);
        this.horizontalSource = (this.data[10] & 8) != 0 ? ((this.data[10] & 4) != 0 ? Angle.TRUE_TRACK : Angle.MAGNETIC_TRACK) : ((this.data[10] & 4) != 0 ? Angle.TRUE_HEADING : Angle.MAGNETIC_HEADING);
        return this;
    }

    @Override
    public void apply(Track track) {
        track.setVersion(Version.VERSION2);
    }

    public SurfaceCapability getSurfaceCapability() {
        return this.surfaceCapability;
    }

    public SurfaceOperationalMode getOperationalMode() {
        return this.operationalMode;
    }

    public LengthWidthCode getLengthWidthCode() {
        return this.lengthWidthCode;
    }

    public NavigationIntegrityCategory getNICp() {
        return this.NICp;
    }

    public Angle getHorizontalSource() {
        return this.horizontalSource;
    }

    public SourceIntegrityLevelSupplement getSILsupp() {
        return this.SILsupp;
    }

    public SourceIntegrityLevel getSIL() {
        return this.SIL;
    }

    public Version getVerison() {
        return this.verison;
    }
}

