/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Acas;
import aero.t2s.modes.Track;
import aero.t2s.modes.constants.ResolutionAdvisory;
import aero.t2s.modes.constants.ThreatTypeIndicator;
import aero.t2s.modes.decoder.AltitudeEncoding;
import aero.t2s.modes.decoder.Common;
import aero.t2s.modes.decoder.df.df17.AircraftStatusMessage;

public class AircraftStatusMessageAcasRA
extends AircraftStatusMessage {
    private int subType = 2;
    private ResolutionAdvisory resolutionAdvisory;
    private boolean multipleThreats;
    private boolean RANotPassBelow;
    private boolean RANotPassAbove;
    private boolean RANotTurnLeft;
    private boolean RANotTurnRight;
    private ThreatTypeIndicator threatTypeIndicator;
    private String threatModeS;
    private double threatAltitude;
    private double threatRange;
    private int threatBearing;

    public AircraftStatusMessageAcasRA(short[] data) {
        super(data);
    }

    @Override
    public AircraftStatusMessage decode() {
        int ara = this.data[5] << 6 | this.data[6] >>> 3;
        int rac = (this.data[6] & 3) << 2 | this.data[7] >>> 6;
        int rat = this.data[7] >>> 5 & 1;
        this.multipleThreats = (this.data[7] >>> 4 & 1) == 1;
        int tti = this.data[7] >>> 2 & 3;
        int tid = (this.data[7] & 3) << 24 | this.data[8] << 16 | this.data[9] << 8 | this.data[10];
        this.resolutionAdvisory = new ResolutionAdvisory(ara);
        this.RANotPassBelow = rac >>> 3 == 1;
        this.RANotPassAbove = (rac >>> 2 & 1) == 1;
        this.RANotTurnLeft = (rac >>> 1 & 1) == 1;
        this.RANotTurnLeft = (rac & 1) == 1;
        this.threatTypeIndicator = ThreatTypeIndicator.from(tti);
        if (rat == 1) {
            this.resolutionAdvisory = new ResolutionAdvisory();
            this.RANotPassBelow = false;
            this.RANotPassAbove = false;
            this.RANotTurnLeft = false;
            this.RANotTurnRight = false;
            this.multipleThreats = false;
        }
        switch (this.threatTypeIndicator) {
            case MODES: {
                this.threatModeS = Common.icao(Common.toHexString(new short[]{(short)(this.data[7] & 3), this.data[8], this.data[9], this.data[10]}));
                break;
            }
            case ALT_BRG_DIST: {
                this.threatAltitude = AltitudeEncoding.decodeModeC(tid >>> 13).getAltitude();
                this.threatRange = Common.tidr(tid >>> 6 & 0x7F);
                this.threatBearing = Common.tidb(tid & 0x3F);
            }
        }
        return this;
    }

    @Override
    public void apply(Track track) {
        Acas acas = track.getAcas();
        acas.getResolutionAdvisory().update(this.resolutionAdvisory);
        acas.setRANotPassBelow(this.RANotPassBelow);
        acas.setRANotPassAbove(this.RANotPassAbove);
        acas.setRANotTurnLeft(this.RANotTurnLeft);
        acas.setRANotTurnRight(this.RANotTurnRight);
        acas.setMultipleThreats(this.multipleThreats);
        acas.setThreatType(this.threatTypeIndicator);
        switch (this.threatTypeIndicator) {
            case MODES: {
                acas.setTargetModeS(this.threatModeS);
                break;
            }
            case ALT_BRG_DIST: {
                acas.setTargetAltitude(this.threatAltitude);
                acas.setTargetRange(this.threatRange);
                acas.setTargetBearing(this.threatBearing);
            }
        }
    }

    public int getSubType() {
        return this.subType;
    }

    public ResolutionAdvisory getResolutionAdvisory() {
        return this.resolutionAdvisory;
    }

    public boolean isMultipleThreats() {
        return this.multipleThreats;
    }

    public boolean isRANotPassBelow() {
        return this.RANotPassBelow;
    }

    public boolean isRANotPassAbove() {
        return this.RANotPassAbove;
    }

    public boolean isRANotTurnLeft() {
        return this.RANotTurnLeft;
    }

    public boolean isRANotTurnRight() {
        return this.RANotTurnRight;
    }

    public ThreatTypeIndicator getThreatTypeIndicator() {
        return this.threatTypeIndicator;
    }

    public String getThreatModeS() {
        return this.threatModeS;
    }

    public double getThreatAltitude() {
        return this.threatAltitude;
    }

    public double getThreatRange() {
        return this.threatRange;
    }

    public int getThreatBearing() {
        return this.threatBearing;
    }
}

