/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes;

import aero.t2s.modes.EmptyMessageException;
import aero.t2s.modes.ModeSHandler;
import aero.t2s.modes.Track;
import aero.t2s.modes.database.ModeSDatabase;
import aero.t2s.modes.decoder.Decoder;
import aero.t2s.modes.decoder.UnknownDownlinkFormatException;
import aero.t2s.modes.decoder.df.DownlinkFormat;
import aero.t2s.modes.decoder.df.df17.InvalidExtendedSquitterTypeCodeException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeSTrackHandler
extends ModeSHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModeSTrackHandler.class);
    private final Decoder decoder;
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final Map<String, Track> tracks;
    private boolean cleanupEnabled = true;
    private final Timer timer;

    public ModeSTrackHandler(Map<String, Track> tracks, double originLat, double originLon, ModeSDatabase database) {
        this.tracks = tracks;
        this.decoder = new Decoder(tracks, originLat, originLon, database);
        this.timer = new Timer();
    }

    @Override
    public void start() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!ModeSTrackHandler.this.cleanupEnabled) {
                    return;
                }
                ArrayList expired = new ArrayList();
                ModeSTrackHandler.this.tracks.values().stream().filter(Track::isExpired).forEach(track -> expired.add(track.getIcao()));
                expired.forEach(icao -> ModeSTrackHandler.this.onDeleted.accept(ModeSTrackHandler.this.tracks.remove(icao)));
            }
        }, 1000L, 5000L);
    }

    @Override
    public void stop() {
        this.timer.cancel();
    }

    @Override
    public void handle(String input) {
        this.executor.execute(() -> this.handleSync(input));
    }

    @Override
    public DownlinkFormat handleSync(String input) {
        try {
            DownlinkFormat df = this.decoder.decode(this.toData(input));
            Track track = this.decoder.getTrack(df.getIcao());
            if (track == null) {
                return null;
            }
            df.apply(track);
            track.touch();
            if (track.wasJustCreated()) {
                this.onCreated.accept(track);
            } else {
                this.onUpdated.accept(track);
            }
            if (this.onMessage != null) {
                this.onMessage.accept(df);
            }
            return df;
        }
        catch (EmptyMessageException df) {
        }
        catch (UnknownDownlinkFormatException | InvalidExtendedSquitterTypeCodeException e) {
            LOGGER.error(e.getMessage());
        }
        catch (Throwable throwable) {
            LOGGER.error("Message could not be parsed", throwable);
        }
        return null;
    }

    public void enableCleanup() {
        this.cleanupEnabled = true;
    }

    public void disableCleanup() {
        this.cleanupEnabled = false;
    }
}

