/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.constants;

public class ResolutionAdvisory {
    private boolean requiresCorrectionUpwards;
    private boolean requiresPositiveClimb;
    private boolean requiresCorrectionDownwards;
    private boolean requiresPositiveDescend;
    private boolean requiresCrossing;
    private boolean senseReversal;
    private boolean active;

    public ResolutionAdvisory() {
    }

    public ResolutionAdvisory(int activeResolutionAdvisory) {
        this.update(activeResolutionAdvisory);
    }

    public void update(ResolutionAdvisory advisory) {
        this.requiresCorrectionUpwards = advisory.isRequiresCorrectionUpwards();
        this.requiresPositiveClimb = advisory.isRequiresPositiveClimb();
        this.requiresCorrectionDownwards = advisory.isRequiresCorrectionDownwards();
        this.requiresPositiveDescend = advisory.isRequiresPositiveDescend();
        this.requiresCrossing = advisory.isRequiresCrossing();
        this.senseReversal = advisory.isSenseReversal();
        this.active = advisory.isActive();
    }

    public void update(int ara) {
        this.requiresCorrectionUpwards = ara >>> 12 == 1;
        this.requiresPositiveClimb = ara >>> 11 == 1;
        this.requiresCorrectionDownwards = ara >>> 10 == 1;
        this.requiresPositiveDescend = ara >>> 9 == 1;
        this.requiresCrossing = ara >>> 8 == 1;
        boolean bl = this.senseReversal = ara >>> 7 == 1;
        if (!this.active && ara >>> 13 == 1) {
            this.active = true;
        }
    }

    public void clear() {
        this.requiresCorrectionUpwards = false;
        this.requiresPositiveClimb = false;
        this.requiresCorrectionDownwards = false;
        this.requiresPositiveDescend = false;
        this.requiresCrossing = false;
        this.senseReversal = false;
        this.active = false;
    }

    public boolean isRequiresCorrectionUpwards() {
        return this.requiresCorrectionUpwards;
    }

    public boolean isRequiresPositiveClimb() {
        return this.requiresPositiveClimb;
    }

    public boolean isRequiresCorrectionDownwards() {
        return this.requiresCorrectionDownwards;
    }

    public boolean isRequiresPositiveDescend() {
        return this.requiresPositiveDescend;
    }

    public boolean isRequiresCrossing() {
        return this.requiresCrossing;
    }

    public boolean isSenseReversal() {
        return this.senseReversal;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String toString() {
        Object out = "\n";
        if (this.requiresCorrectionUpwards) {
            out = (String)out + " - RA requires a correction in the upward sense";
        }
        if (this.requiresPositiveClimb) {
            out = (String)out + " - RA requires a positive climb";
        }
        if (this.requiresCorrectionDownwards) {
            out = (String)out + " - RA requires a correction in the downward sense";
        }
        if (this.requiresPositiveDescend) {
            out = (String)out + " - RA requires a positive descend";
        }
        if (this.requiresCrossing) {
            out = (String)out + " - RA requires a crossing";
        }
        if (this.senseReversal) {
            out = (String)out + " - RA is a sense reversal";
        }
        return out;
    }
}

