/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.df.DownlinkFormat;
import aero.t2s.modes.decoder.df.df17.AirbornePosition;
import aero.t2s.modes.decoder.df.df17.AirborneVelocity;
import aero.t2s.modes.decoder.df.df17.AircraftIdentification;
import aero.t2s.modes.decoder.df.df17.AircraftOperationalStatusMessage;
import aero.t2s.modes.decoder.df.df17.AircraftStatusMessage;
import aero.t2s.modes.decoder.df.df17.ExtendedSquitter;
import aero.t2s.modes.decoder.df.df17.InvalidExtendedSquitterTypeCodeException;
import aero.t2s.modes.decoder.df.df17.ReservedMessage;
import aero.t2s.modes.decoder.df.df17.SurfacePosition;
import aero.t2s.modes.decoder.df.df17.SurfaceSystemStatus;
import aero.t2s.modes.decoder.df.df17.TargetStatusMessage;
import aero.t2s.modes.decoder.df.df17.TestMessage;

public class DF17
extends DownlinkFormat {
    private final double originLat;
    private final double originLon;
    private ExtendedSquitter extendedSquitter;

    public DF17(short[] data, double originLat, double originLon) {
        super(data, DownlinkFormat.IcaoAddress.FROM_MESSAGE);
        this.originLat = originLat;
        this.originLon = originLon;
    }

    @Override
    public DF17 decode() {
        int typeCode = this.data[4] >>> 3;
        switch (typeCode) {
            case 0: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                this.extendedSquitter = new AirbornePosition(this.data, this.originLat, this.originLon);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.extendedSquitter = new AircraftIdentification(this.data);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.extendedSquitter = new SurfacePosition(this.data);
                break;
            }
            case 19: {
                this.extendedSquitter = new AirborneVelocity(this.data);
                break;
            }
            case 23: {
                this.extendedSquitter = new TestMessage(this.data);
                break;
            }
            case 24: {
                this.extendedSquitter = new SurfaceSystemStatus(this.data);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                this.extendedSquitter = new ReservedMessage(this.data);
                break;
            }
            case 28: {
                this.extendedSquitter = new AircraftStatusMessage(this.data);
                break;
            }
            case 29: {
                this.extendedSquitter = new TargetStatusMessage(this.data);
                break;
            }
            case 31: {
                this.extendedSquitter = new AircraftOperationalStatusMessage(this.data);
                break;
            }
            default: {
                logger.warn("Mode-S: No parser found for DF-17 type code {}. Packet ignored", (Object)typeCode);
                throw new InvalidExtendedSquitterTypeCodeException(typeCode);
            }
        }
        this.extendedSquitter = this.extendedSquitter.decode();
        return this;
    }

    @Override
    public void apply(Track track) {
        this.extendedSquitter.apply(track);
    }

    public ExtendedSquitter getExtendedSquitter() {
        return this.extendedSquitter;
    }
}

